/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.info;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.jcr.Property;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.commons.chain.Context;
import org.apache.jackrabbit.standalone.cli.CommandHelper;
import org.apache.jackrabbit.standalone.cli.info.AbstractLs;
import org.apache.jackrabbit.standalone.cli.info.PrintHelper;

public abstract class AbstractLsProperties
extends AbstractLs {
    private static ResourceBundle bundle = CommandHelper.getBundle();
    private static final int LENGTH_LENGTH = 8;

    public final boolean execute(Context ctx) throws Exception {
        int[] width = new int[]{30, this.longWidth, this.longWidth, 8, 18};
        String[] header = new String[]{bundle.getString("word.name"), bundle.getString("word.multiple"), bundle.getString("word.type"), bundle.getString("word.length"), bundle.getString("word.preview")};
        PrintHelper.printRow(ctx, width, header);
        PrintHelper.printSeparatorRow(ctx, width, '-');
        Iterator iter = this.getProperties(ctx);
        int maxItems = this.getMaxItems(ctx);
        for (int index = 0; iter.hasNext() && index < maxItems; ++index) {
            Property p = (Property)iter.next();
            long length = 0L;
            if (p.getDefinition().isMultiple()) {
                long[] lengths = p.getLengths();
                for (int i = 0; i < lengths.length; ++i) {
                    length += lengths[i];
                }
            } else {
                length = p.getLength();
            }
            String multiple = Boolean.toString(p.getDefinition().isMultiple());
            if (p.getDefinition().isMultiple()) {
                multiple = multiple + "[" + p.getValues().length + "]";
            }
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(p.getName());
            row.add(multiple);
            row.add(PropertyType.nameFromValue(p.getType()));
            row.add(Long.toString(length));
            if (p.getDefinition().isMultiple()) {
                row.add(this.getMultiplePreview(p));
            } else {
                row.add(this.getPreview(p));
            }
            PrintHelper.printRow(ctx, width, row);
        }
        CommandHelper.getOutput(ctx).println();
        this.printFooter(ctx, iter);
        return false;
    }

    protected abstract Iterator getProperties(Context var1) throws Exception;

    private String getPreview(Property p) throws RepositoryException {
        String value = p.getValue().getString();
        return value.substring(0, Math.min(value.length(), 50));
    }

    private Collection getMultiplePreview(Property p) throws ValueFormatException, RepositoryException {
        ArrayList<String> c = new ArrayList<String>();
        Value[] values = p.getValues();
        for (int i = 0; i < values.length; ++i) {
            try {
                String value = values[i].getString();
                c.add(value.substring(0, Math.min(value.length(), 50)));
                continue;
            }
            catch (ValueFormatException e) {
                c.add(bundle.getString("phrase.notavailable"));
            }
        }
        return c;
    }
}

