/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.info;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.cli.HelpFormatter;
import org.apache.jackrabbit.standalone.cli.AbstractParameter;
import org.apache.jackrabbit.standalone.cli.CommandException;
import org.apache.jackrabbit.standalone.cli.CommandHelper;
import org.apache.jackrabbit.standalone.cli.CommandLine;
import org.apache.jackrabbit.standalone.cli.CommandLineFactory;
import org.apache.jackrabbit.standalone.cli.Option;
import org.apache.jackrabbit.standalone.cli.info.PrintHelper;

public class Help
implements Command {
    private static ResourceBundle bundle = CommandHelper.getBundle();
    private CommandLineFactory factory = CommandLineFactory.getInstance();
    private HelpFormatter hf = new HelpFormatter();
    private String commandKey = "command";

    public boolean execute(Context ctx) throws Exception {
        String command = (String)ctx.get(this.commandKey);
        PrintWriter out = CommandHelper.getOutput(ctx);
        out.println();
        if (command == null) {
            this.helpAll(ctx);
        } else {
            this.helpCommand(ctx);
        }
        return false;
    }

    private void helpAll(Context ctx) throws CommandException {
        PrintWriter out = CommandHelper.getOutput(ctx);
        Collection descriptors = this.factory.getCommandLines();
        Iterator iter = descriptors.iterator();
        int tabPos = 20;
        while (iter.hasNext()) {
            CommandLine desc = (CommandLine)iter.next();
            if (desc.getName().length() <= tabPos) continue;
            tabPos = desc.getName().length() + 1;
        }
        for (CommandLine desc : descriptors) {
            StringBuffer buf = new StringBuffer(desc.getName());
            buf.setLength(tabPos);
            for (int i = desc.getName().length(); i < buf.length(); ++i) {
                buf.setCharAt(i, ' ');
            }
            buf.append(desc.getLocalizedDescription());
            this.hf.printWrapped(out, 70, tabPos, buf.toString());
        }
    }

    private void helpCommand(Context ctx) throws CommandException {
        PrintWriter out = CommandHelper.getOutput(ctx);
        String cmdName = (String)ctx.get(this.commandKey);
        CommandLine desc = this.factory.getCommandLine(cmdName);
        out.println(this.getString(bundle, "word.description") + ": ");
        out.println(desc.getLocalizedDescription());
        out.println();
        out.print(this.getString(bundle, "word.usage") + ":");
        out.print(desc.getName() + " ");
        for (AbstractParameter arg : desc.getArguments().values()) {
            out.print("<" + ((Option)arg).getLocalizedArgName() + "> ");
        }
        for (AbstractParameter arg : desc.getOptions().values()) {
            out.print("-" + arg.getName() + " <" + ((Option)arg).getLocalizedArgName() + "> ");
        }
        for (AbstractParameter arg : desc.getFlags().values()) {
            out.print("-" + arg.getName() + " ");
        }
        out.println();
        if (desc.getAlias().size() > 0) {
            out.print(this.getString(bundle, "word.alias") + ":");
            Iterator<Object> iter = desc.getAlias().iterator();
            while (iter.hasNext()) {
                out.print((String)iter.next() + " ");
            }
            out.println();
        }
        out.println();
        if (desc.getArguments().size() > 0) {
            out.println("<" + this.getString(bundle, "word.arguments") + ">");
            this.printParam(ctx, desc.getArguments().values());
        }
        if (desc.getOptions().values().size() > 0) {
            out.println();
            out.println("<" + this.getString(bundle, "word.options") + ">");
            this.printParam(ctx, desc.getOptions().values());
        }
        if (desc.getFlags().values().size() > 0) {
            out.println();
            out.println("<" + this.getString(bundle, "word.flags") + ">");
            this.printParam(ctx, desc.getFlags().values());
        }
    }

    private void printParam(Context ctx, Collection params) {
        int[] width = new int[]{10, 10, 10, 40};
        String[] header = new String[]{this.getString(bundle, "word.name"), this.getString(bundle, "word.argument"), this.getString(bundle, "word.required"), this.getString(bundle, "word.description")};
        PrintHelper.printRow(ctx, width, header);
        PrintHelper.printSeparatorRow(ctx, width, '-');
        for (AbstractParameter p : params) {
            String[] item = new String[]{p.getName(), p.getLocalizedArgName(), Boolean.toString(p.isRequired()), p.getLocalizedDescription()};
            PrintHelper.printRow(ctx, width, item);
        }
    }

    public String getCommandKey() {
        return this.commandKey;
    }

    public void setCommandKey(String commandKey) {
        this.commandKey = commandKey;
    }

    private String getString(ResourceBundle bundle, String key) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return "not available";
        }
    }
}

