/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.info;

import java.io.PrintWriter;
import javax.jcr.Session;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.jackrabbit.standalone.cli.CommandException;
import org.apache.jackrabbit.standalone.cli.CommandHelper;

public class Info
implements Command {
    public boolean execute(Context ctx) throws Exception {
        String currentPath;
        Session session;
        PrintWriter out = CommandHelper.getOutput(ctx);
        out.println();
        try {
            CommandHelper.getRepository(ctx);
        }
        catch (CommandException e) {
            out.println("No connection to a repository.");
            return false;
        }
        out.println("Repository: " + CommandHelper.getRepositoryAddress(ctx));
        try {
            session = CommandHelper.getSession(ctx);
            currentPath = CommandHelper.getCurrentNode(ctx).getPath();
        }
        catch (CommandException e) {
            out.println("Not logged in / no session.");
            return false;
        }
        out.println("User      : " + session.getUserID());
        out.println("Workspace : " + session.getWorkspace().getName());
        out.println("Node      : " + currentPath);
        out.println();
        if (session.isLive()) {
            out.println("Session is live.");
        } else {
            out.println("Session is not live.");
        }
        if (session.hasPendingChanges()) {
            out.println("Session has pending changes.");
        } else {
            out.println("Session has no changes.");
        }
        return false;
    }
}

