/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.info;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.version.Version;
import javax.jcr.version.VersionIterator;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.jackrabbit.standalone.cli.CommandHelper;
import org.apache.jackrabbit.standalone.cli.info.PrintHelper;

public class LsVersions
implements Command {
    private static ResourceBundle bundle = CommandHelper.getBundle();
    private String pathKey = "path";

    public boolean execute(Context ctx) throws Exception {
        String path = (String)ctx.get(this.pathKey);
        Node n = CommandHelper.getNode(ctx, path);
        int[] width = new int[]{20, 50};
        String[] header = new String[]{bundle.getString("word.version"), bundle.getString("word.labels")};
        PrintHelper.printRow(ctx, width, header);
        PrintHelper.printSeparatorRow(ctx, width, '-');
        VersionIterator iter = n.getVersionHistory().getAllVersions();
        while (iter.hasNext()) {
            Version v = iter.nextVersion();
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(v.getName());
            row.add(Arrays.asList(n.getVersionHistory().getVersionLabels(v)));
            PrintHelper.printRow(ctx, width, row);
        }
        return false;
    }

    public String getPathKey() {
        return this.pathKey;
    }

    public void setPathKey(String pathKey) {
        this.pathKey = pathKey;
    }
}

