/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.version;

import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.standalone.cli.CommandHelper;

public class Merge
implements Command {
    private static Log log = LogFactory.getLog(Merge.class);
    private String pathKey = "path";
    private String srcWorkspaceKey = "srcWorkspace";
    private String bestEffortKey = "bestEffort";

    public boolean execute(Context ctx) throws Exception {
        String path = (String)ctx.get(this.pathKey);
        String srcWorkspace = (String)ctx.get(this.srcWorkspaceKey);
        boolean bestEffort = Boolean.valueOf((String)ctx.get(this.bestEffortKey));
        if (log.isDebugEnabled()) {
            log.debug("merging node at " + path + " from workspace " + srcWorkspace + " besteffort=" + bestEffort);
        }
        CommandHelper.getNode(ctx, path).merge(srcWorkspace, bestEffort);
        return false;
    }

    public String getBestEffortKey() {
        return this.bestEffortKey;
    }

    public void setBestEffortKey(String bestEffortKey) {
        this.bestEffortKey = bestEffortKey;
    }

    public String getPathKey() {
        return this.pathKey;
    }

    public void setPathKey(String pathKey) {
        this.pathKey = pathKey;
    }

    public String getSrcWorkspaceKey() {
        return this.srcWorkspaceKey;
    }

    public void setSrcWorkspaceKey(String srcWorkspaceKey) {
        this.srcWorkspaceKey = srcWorkspaceKey;
    }
}

