/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.version;

import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.standalone.cli.CommandHelper;

public class RemoveVersionByLabel
implements Command {
    private static Log log = LogFactory.getLog(RemoveVersionByLabel.class);
    private String pathKey = "path";
    private String labelKey = "label";

    public boolean execute(Context ctx) throws Exception {
        String path = (String)ctx.get(this.pathKey);
        String label = (String)ctx.get(this.labelKey);
        if (log.isDebugEnabled()) {
            log.debug("Remove version with label " + label + " from node " + path);
        }
        VersionHistory vh = CommandHelper.getNode(ctx, path).getVersionHistory();
        Version v = vh.getVersionByLabel(label);
        vh.removeVersion(v.getName());
        return false;
    }

    public String getPathKey() {
        return this.pathKey;
    }

    public void setPathKey(String pathKey) {
        this.pathKey = pathKey;
    }

    public String getLabelKey() {
        return this.labelKey;
    }

    public void setLabelKey(String versionNameKey) {
        this.labelKey = versionNameKey;
    }
}

