/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.xml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.standalone.cli.CommandException;
import org.apache.jackrabbit.standalone.cli.CommandHelper;

public abstract class AbstractExportViewToFile
implements Command {
    private static Log log = LogFactory.getLog(AbstractExportViewToFile.class);
    protected String srcAbsPathKey = "srcAbsPath";
    protected String desFsPathKey = "desFsPath";
    protected String overwriteKey = "overwrite";
    protected String skipBinaryKey = "skipBinary";
    protected String noRecurseKey = "noRecurse";

    protected OutputStream getOutputStream(Context ctx) throws CommandException, IOException {
        String to = (String)ctx.get(this.desFsPathKey);
        boolean overwrite = Boolean.valueOf((String)ctx.get(this.overwriteKey));
        File f = new File(to);
        if (f.exists() && !overwrite) {
            throw new CommandException("exception.file.exists", new String[]{to});
        }
        if (!f.exists()) {
            f.createNewFile();
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
        return out;
    }

    public String getNoRecurseKey() {
        return this.noRecurseKey;
    }

    public void setNoRecurseKey(String noRecurseKey) {
        this.noRecurseKey = noRecurseKey;
    }

    public String getOverwriteKey() {
        return this.overwriteKey;
    }

    public void setOverwriteKey(String overwriteKey) {
        this.overwriteKey = overwriteKey;
    }

    public String getSkipBinaryKey() {
        return this.skipBinaryKey;
    }

    public void setSkipBinaryKey(String skipBinaryKey) {
        this.skipBinaryKey = skipBinaryKey;
    }

    public String getSrcAbsPathKey() {
        return this.srcAbsPathKey;
    }

    public void setSrcAbsPathKey(String fromKey) {
        this.srcAbsPathKey = fromKey;
    }

    public String getDesFsPathKey() {
        return this.desFsPathKey;
    }

    public void setDesFsPathKey(String toKey) {
        this.desFsPathKey = toKey;
    }

    public final boolean execute(Context ctx) throws Exception {
        boolean skipBinary = Boolean.valueOf((String)ctx.get(this.skipBinaryKey));
        boolean noRecurse = Boolean.valueOf((String)ctx.get(this.noRecurseKey));
        String fromStr = (String)ctx.get(this.srcAbsPathKey);
        if (log.isDebugEnabled()) {
            log.debug("exporting view from " + fromStr);
        }
        Node from = CommandHelper.getNode(ctx, fromStr);
        OutputStream out = this.getOutputStream(ctx);
        this.exportView(from, out, skipBinary, noRecurse);
        out.close();
        return false;
    }

    protected abstract void exportView(Node var1, OutputStream var2, boolean var3, boolean var4) throws PathNotFoundException, IOException, RepositoryException;
}

