/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr.nodetype;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.webdav.jcr.nodetype.NodeTypeConstants;
import org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTypeProperty
extends AbstractDavProperty<Set<String>>
implements NodeTypeConstants {
    private static Logger log = LoggerFactory.getLogger(NodeTypeProperty.class);
    private final Set<String> nodetypeNames = new HashSet<String>();

    public NodeTypeProperty(DavPropertyName name, NodeType nodeType, boolean isProtected) {
        this(name, new NodeType[]{nodeType}, isProtected);
    }

    public NodeTypeProperty(DavPropertyName name, NodeType[] nodeTypes, boolean isProtected) {
        super(name, isProtected);
        for (NodeType nt : nodeTypes) {
            if (nt == null) continue;
            this.nodetypeNames.add(nt.getName());
        }
    }

    public NodeTypeProperty(DavPropertyName name, String[] nodeTypeNames, boolean isProtected) {
        super(name, isProtected);
        for (String nodeTypeName : nodeTypeNames) {
            if (nodeTypeName == null) continue;
            this.nodetypeNames.add(nodeTypeName);
        }
    }

    public NodeTypeProperty(DavProperty<?> property) {
        super(property.getName(), property.isInvisibleInAllprop());
        if (property instanceof NodeTypeProperty) {
            this.nodetypeNames.addAll(((NodeTypeProperty)property).nodetypeNames);
        } else {
            Object propValue = property.getValue();
            if (propValue instanceof List) {
                this.retrieveNodeTypeNames((List)propValue);
            } else if (propValue instanceof Element) {
                List<Element> l = Collections.singletonList((Element)propValue);
                this.retrieveNodeTypeNames(l);
            } else {
                log.debug("NodeTypeProperty '" + property.getName() + "' has no/unparsable value.");
            }
        }
    }

    private void retrieveNodeTypeNames(List<?> elementList) {
        for (Object content : elementList) {
            if (!(content instanceof Element)) continue;
            Element el = (Element)content;
            if ("nodetype".equals(el.getLocalName()) && NodeTypeConstants.NAMESPACE.isSame(el.getNamespaceURI())) {
                String nodetypeName = DomUtil.getChildText(el, "nodetypename", NodeTypeConstants.NAMESPACE);
                if (nodetypeName == null || "".equals(nodetypeName)) continue;
                this.nodetypeNames.add(nodetypeName);
                continue;
            }
            log.debug("'dcr:nodetype' element expected -> ignoring element '" + ((Element)content).getNodeName() + "'");
        }
    }

    public Set<String> getNodeTypeNames() {
        return this.nodetypeNames;
    }

    @Override
    public Set<String> getValue() {
        return this.nodetypeNames;
    }

    @Override
    public Element toXml(Document document) {
        Element elem = this.getName().toXml(document);
        for (String name : this.getNodeTypeNames()) {
            Element ntElem = DomUtil.addChildElement(elem, "nodetype", NodeTypeConstants.NAMESPACE);
            DomUtil.addChildElement(ntElem, "nodetypename", NodeTypeConstants.NAMESPACE, name);
        }
        return elem;
    }
}

