/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import java.io.IOException;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;

public abstract class COSNumber
extends COSBase {
    public static final COSInteger ZERO = new COSInteger(0);
    public static final COSInteger ONE = new COSInteger(1);
    private static final COSInteger[] DIGITS = new COSInteger[]{ZERO, ONE, new COSInteger(2), new COSInteger(3), new COSInteger(4), new COSInteger(5), new COSInteger(6), new COSInteger(7), new COSInteger(8), new COSInteger(9)};

    public abstract float floatValue();

    public abstract double doubleValue();

    public abstract int intValue();

    public abstract long longValue();

    public static COSNumber get(String number) throws IOException {
        if (number.length() == 1) {
            char digit = number.charAt(0);
            if ('0' <= digit && digit <= '9') {
                return DIGITS[digit - 48];
            }
            throw new IOException("Not a number: " + number);
        }
        if (number.indexOf(46) == -1) {
            return new COSInteger(number);
        }
        return new COSFloat(number);
    }
}

