/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfviewer;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.PDGraphicsState;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.PDFStreamEngine;
import org.apache.pdfbox.util.ResourceLoader;
import org.apache.pdfbox.util.TextPosition;

public class PageDrawer
extends PDFStreamEngine {
    private static final Log log = LogFactory.getLog(PageDrawer.class);
    private Graphics2D graphics;
    private Dimension pageSize;
    private PDPage page;
    private GeneralPath linePath = new GeneralPath();

    public PageDrawer() throws IOException {
        super(ResourceLoader.loadProperties("Resources/PageDrawer.properties", true));
    }

    public void drawPage(Graphics g, PDPage p, Dimension pageDimension) throws IOException {
        this.graphics = (Graphics2D)g;
        this.page = p;
        this.pageSize = pageDimension;
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        if (this.page.getContents() != null) {
            PDResources resources = this.page.findResources();
            this.processStream(this.page, resources, this.page.getContents().getStream());
        }
        List annotations = this.page.getAnnotations();
        for (int i = 0; i < annotations.size(); ++i) {
            Map appearanceMap;
            PDAppearanceStream appearance;
            PDAnnotation annot = (PDAnnotation)annotations.get(i);
            PDRectangle rect = annot.getRectangle();
            String appearanceName = annot.getAppearanceStream();
            PDAppearanceDictionary appearDictionary = annot.getAppearance();
            if (appearDictionary == null) continue;
            if (appearanceName == null) {
                appearanceName = "default";
            }
            if ((appearance = (PDAppearanceStream)(appearanceMap = appearDictionary.getNormalAppearance()).get(appearanceName)) == null) continue;
            g.translate((int)rect.getLowerLeftX(), (int)(-rect.getLowerLeftY()));
            this.processSubStream(this.page, appearance.getResources(), appearance.getStream());
            g.translate((int)(-rect.getLowerLeftX()), (int)rect.getLowerLeftY());
        }
    }

    protected void processTextPosition(TextPosition text) {
        try {
            if (this.getGraphicsState().getTextState().getRenderingMode() == 0) {
                this.graphics.setColor(this.getGraphicsState().getNonStrokingColor().getJavaColor());
            } else if (this.getGraphicsState().getTextState().getRenderingMode() == 1) {
                this.graphics.setColor(this.getGraphicsState().getStrokingColor().getJavaColor());
            } else {
                log.warn("Unsupported RenderingMode " + this.getGraphicsState().getTextState().getRenderingMode() + " in PageDrawer.processTextPosition()." + " Using RenderingMode " + 0 + " instead");
                this.graphics.setColor(this.getGraphicsState().getNonStrokingColor().getJavaColor());
            }
            PDFont font = text.getFont();
            Matrix textPos = text.getTextPos().copy();
            float x = textPos.getXPosition();
            float y = (float)this.pageSize.height - textPos.getYPosition();
            textPos.setValue(2, 0, 0.0f);
            textPos.setValue(2, 1, 0.0f);
            textPos.setValue(0, 1, -1.0f * textPos.getValue(0, 1));
            textPos.setValue(1, 0, -1.0f * textPos.getValue(1, 0));
            AffineTransform at = textPos.createAffineTransform();
            this.graphics.setClip(this.getGraphicsState().getCurrentClippingPath());
            font.drawString(text.getCharacter(), this.graphics, text.getFontSize(), at, x, y);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    public PDPage getPage() {
        return this.page;
    }

    public Dimension getPageSize() {
        return this.pageSize;
    }

    public double fixY(double y) {
        return this.pageSize.getHeight() - y;
    }

    public GeneralPath getLinePath() {
        return this.linePath;
    }

    public void setLinePath(GeneralPath newLinePath) {
        if (this.linePath == null || this.linePath.getCurrentPoint() == null) {
            this.linePath = newLinePath;
        } else {
            this.linePath.append(newLinePath, false);
        }
    }

    public void fillPath(int windingRule) throws IOException {
        this.graphics.setColor(this.getGraphicsState().getNonStrokingColor().getJavaColor());
        this.getLinePath().setWindingRule(windingRule);
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.graphics.setClip(this.getGraphicsState().getCurrentClippingPath());
        this.graphics.fill(this.getLinePath());
        this.getLinePath().reset();
    }

    public void setStroke(BasicStroke newStroke) {
        this.getGraphics().setStroke(newStroke);
    }

    public void strokePath() throws IOException {
        this.graphics.setColor(this.getGraphicsState().getStrokingColor().getJavaColor());
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.graphics.setClip(this.getGraphicsState().getCurrentClippingPath());
        GeneralPath path = this.getLinePath();
        this.graphics.draw(path);
        path.reset();
    }

    public void colorChanged(boolean bStroking) throws IOException {
    }

    public Point2D.Double transformedPoint(double x, double y) {
        double[] position = new double[]{x, y};
        this.getGraphicsState().getCurrentTransformationMatrix().createAffineTransform().transform(position, 0, position, 0, 1);
        position[1] = this.fixY(position[1]);
        return new Point2D.Double(position[0], position[1]);
    }

    public void setClippingPath(int windingRule) {
        PDGraphicsState graphicsState = this.getGraphicsState();
        GeneralPath clippingPath = (GeneralPath)this.getLinePath().clone();
        clippingPath.setWindingRule(windingRule);
        if (graphicsState.getCurrentClippingPath() != null) {
            Area currentArea = new Area(this.getGraphicsState().getCurrentClippingPath());
            Area newArea = new Area(clippingPath);
            currentArea.intersect(newArea);
            graphicsState.setCurrentClippingPath(currentArea);
        } else {
            graphicsState.setCurrentClippingPath(clippingPath);
        }
        this.getLinePath().reset();
    }
}

