/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.encryption;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.encryption.ARCFour;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.DecryptionMaterial;

public abstract class SecurityHandler {
    private static final int DEFAULT_KEY_LENGTH = 40;
    protected int version;
    protected int keyLength = 40;
    protected byte[] encryptionKey;
    protected PDDocument document;
    protected ARCFour rc4 = new ARCFour();
    private Set objects = new HashSet();
    private Set potentialSignatures = new HashSet();
    protected AccessPermission currentAccessPermission = null;

    public abstract void prepareDocumentForEncryption(PDDocument var1) throws CryptographyException, IOException;

    public abstract void decryptDocument(PDDocument var1, DecryptionMaterial var2) throws CryptographyException, IOException;

    protected void proceedDecryption() throws IOException, CryptographyException {
        COSDictionary trailer = this.document.getDocument().getTrailer();
        COSArray fields = (COSArray)trailer.getObjectFromPath("Root/AcroForm/Fields");
        if (fields != null) {
            for (int i = 0; i < fields.size(); ++i) {
                COSDictionary field = (COSDictionary)fields.getObject(i);
                this.addDictionaryAndSubDictionary(this.potentialSignatures, field);
            }
        }
        List allObjects = this.document.getDocument().getObjects();
        Iterator objectIter = allObjects.iterator();
        while (objectIter.hasNext()) {
            this.decryptObject((COSObject)objectIter.next());
        }
        this.document.setEncryptionDictionary(null);
    }

    private void addDictionaryAndSubDictionary(Set set, COSDictionary dic) {
        set.add(dic);
        COSArray kids = (COSArray)dic.getDictionaryObject("Kids");
        for (int i = 0; kids != null && i < kids.size(); ++i) {
            this.addDictionaryAndSubDictionary(set, (COSDictionary)kids.getObject(i));
        }
        COSBase value = dic.getDictionaryObject("V");
        if (value instanceof COSDictionary) {
            this.addDictionaryAndSubDictionary(set, (COSDictionary)value);
        }
    }

    public void encryptData(long objectNumber, long genNumber, InputStream data, OutputStream output) throws CryptographyException, IOException {
        byte[] newKey = new byte[this.encryptionKey.length + 5];
        System.arraycopy(this.encryptionKey, 0, newKey, 0, this.encryptionKey.length);
        newKey[newKey.length - 5] = (byte)(objectNumber & 0xFFL);
        newKey[newKey.length - 4] = (byte)(objectNumber >> 8 & 0xFFL);
        newKey[newKey.length - 3] = (byte)(objectNumber >> 16 & 0xFFL);
        newKey[newKey.length - 2] = (byte)(genNumber & 0xFFL);
        newKey[newKey.length - 1] = (byte)(genNumber >> 8 & 0xFFL);
        byte[] digestedKey = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            digestedKey = md.digest(newKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptographyException(e);
        }
        int length = Math.min(newKey.length, 16);
        byte[] finalKey = new byte[length];
        System.arraycopy(digestedKey, 0, finalKey, 0, length);
        this.rc4.setKey(finalKey);
        this.rc4.write(data, output);
        output.flush();
    }

    private void decryptObject(COSObject object) throws CryptographyException, IOException {
        long objNum = object.getObjectNumber().intValue();
        long genNum = object.getGenerationNumber().intValue();
        COSBase base = object.getObject();
        this.decrypt(base, objNum, genNum);
    }

    private void decrypt(Object obj, long objNum, long genNum) throws CryptographyException, IOException {
        if (!this.objects.contains(obj)) {
            this.objects.add(obj);
            if (obj instanceof COSString) {
                this.decryptString((COSString)obj, objNum, genNum);
            } else if (obj instanceof COSStream) {
                this.decryptStream((COSStream)obj, objNum, genNum);
            } else if (obj instanceof COSDictionary) {
                this.decryptDictionary((COSDictionary)obj, objNum, genNum);
            } else if (obj instanceof COSArray) {
                this.decryptArray((COSArray)obj, objNum, genNum);
            }
        }
    }

    public void decryptStream(COSStream stream, long objNum, long genNum) throws CryptographyException, IOException {
        this.decryptDictionary(stream, objNum, genNum);
        InputStream encryptedStream = stream.getFilteredStream();
        this.encryptData(objNum, genNum, encryptedStream, stream.createFilteredStream());
    }

    private void decryptDictionary(COSDictionary dictionary, long objNum, long genNum) throws CryptographyException, IOException {
        for (COSName key : dictionary.keyList()) {
            COSBase value = dictionary.getItem(key);
            if (key.getName().equals("Contents") && value instanceof COSString && this.potentialSignatures.contains(dictionary)) continue;
            this.decrypt(value, objNum, genNum);
        }
    }

    public void decryptString(COSString string, long objNum, long genNum) throws CryptographyException, IOException {
        ByteArrayInputStream data = new ByteArrayInputStream(string.getBytes());
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        this.encryptData(objNum, genNum, data, buffer);
        string.reset();
        string.append(buffer.toByteArray());
    }

    private void decryptArray(COSArray array, long objNum, long genNum) throws CryptographyException, IOException {
        for (int i = 0; i < array.size(); ++i) {
            this.decrypt(array.get(i), objNum, genNum);
        }
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public void setKeyLength(int keyLen) {
        this.keyLength = keyLen;
    }

    public AccessPermission getCurrentAccessPermission() {
        return this.currentAccessPermission;
    }
}

