/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.xobject;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;

public class PDCcitt
extends PDXObjectImage {
    private static final Log log = LogFactory.getLog(PDCcitt.class);
    private static final List FAX_FILTERS = new ArrayList();

    public PDCcitt(PDStream ccitt) {
        super(ccitt, "tiff");
    }

    public PDCcitt(PDDocument doc, RandomAccess raf) throws IOException {
        super(new PDStream(doc), "tiff");
        COSDictionary decodeParms = new COSDictionary();
        COSStream dic = this.getCOSStream();
        this.extractFromTiff(raf, this.getCOSStream().createFilteredStream(), decodeParms);
        dic.setItem(COSName.FILTER, (COSBase)COSName.CCITTFAX_DECODE);
        dic.setItem(COSName.SUBTYPE, (COSBase)COSName.IMAGE);
        dic.setItem(COSName.TYPE, (COSBase)COSName.getPDFName("XObject"));
        dic.setItem("DecodeParms", (COSBase)decodeParms);
        this.setBitsPerComponent(1);
        this.setColorSpace(new PDDeviceGray());
        this.setWidth(decodeParms.getInt("Columns"));
        this.setHeight(decodeParms.getInt("Rows"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getRGBImage() throws IOException {
        BufferedImage retval = null;
        TiffWrapper tiff = new TiffWrapper(this.getPDStream().getPartiallyFilteredStream(FAX_FILTERS), this.getCOSStream());
        try {
            retval = ImageIO.read(tiff);
        }
        catch (Exception e) {
            log.error(e, e);
        }
        finally {
            if (tiff != null) {
                tiff.close();
            }
        }
        return retval;
    }

    public void write2OutputStream(OutputStream out) throws IOException {
        TiffWrapper data = new TiffWrapper(this.getPDStream().getPartiallyFilteredStream(FAX_FILTERS), this.getCOSStream());
        byte[] buf = new byte[1024];
        int amountRead = -1;
        while ((amountRead = ((InputStream)data).read(buf)) != -1) {
            out.write(buf, 0, amountRead);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractFromTiff(RandomAccess raf, OutputStream os, COSDictionary parms) throws IOException {
        try {
            raf.seek(0L);
            char endianess = (char)raf.read();
            if ((char)raf.read() != endianess) {
                throw new IOException("Not a valid tiff file");
            }
            if (endianess != 'M' && endianess != 'I') {
                throw new IOException("Not a valid tiff file");
            }
            int magicNumber = this.readshort(endianess, raf);
            if (magicNumber != 42) {
                throw new IOException("Not a valid tiff file");
            }
            raf.seek(this.readlong(endianess, raf));
            int numtags = this.readshort(endianess, raf);
            if (numtags > 50) {
                throw new IOException("Not a valid tiff file");
            }
            int k = -1000;
            int dataoffset = 0;
            int datalength = 0;
            block19: for (int i = 0; i < numtags; ++i) {
                int tag = this.readshort(endianess, raf);
                int type = this.readshort(endianess, raf);
                int count = this.readlong(endianess, raf);
                int val = this.readlong(endianess, raf);
                if (endianess == 'M') {
                    switch (type) {
                        case 1: {
                            val >>= 24;
                            break;
                        }
                        case 3: {
                            val >>= 16;
                            break;
                        }
                        case 4: {
                            break;
                        }
                    }
                }
                switch (tag) {
                    case 256: {
                        parms.setInt("Columns", val);
                        continue block19;
                    }
                    case 257: {
                        parms.setInt("Rows", val);
                        continue block19;
                    }
                    case 259: {
                        if (val == 4) {
                            k = -1;
                        }
                        if (val != 3) continue block19;
                        k = 0;
                        continue block19;
                    }
                    case 262: {
                        if (val != 1) continue block19;
                        parms.setBoolean("BlackIs1", true);
                        continue block19;
                    }
                    case 273: {
                        if (count != 1) continue block19;
                        dataoffset = val;
                        continue block19;
                    }
                    case 279: {
                        if (count != 1) continue block19;
                        datalength = val;
                        continue block19;
                    }
                    case 292: {
                        if (val != 1) continue block19;
                        k = 50;
                        continue block19;
                    }
                    case 324: {
                        if (count != 1) continue block19;
                        dataoffset = val;
                        continue block19;
                    }
                    case 325: {
                        if (count != 1) continue block19;
                        datalength = val;
                        continue block19;
                    }
                }
            }
            if (k == -1000) {
                throw new IOException("First image in tiff is not CCITT T4 or T6 compressed");
            }
            if (dataoffset == 0) {
                throw new IOException("First image in tiff is not a single tile/strip");
            }
            parms.setInt("K", k);
            raf.seek(dataoffset);
            byte[] buf = new byte[8192];
            int amountRead = -1;
            while ((amountRead = raf.read(buf, 0, Math.min(8192, datalength))) > 0) {
                datalength -= amountRead;
                os.write(buf, 0, amountRead);
            }
        }
        finally {
            os.close();
        }
    }

    private int readshort(char endianess, RandomAccess raf) throws IOException {
        if (endianess == 'I') {
            return raf.read() | raf.read() << 8;
        }
        return raf.read() << 8 | raf.read();
    }

    private int readlong(char endianess, RandomAccess raf) throws IOException {
        if (endianess == 'I') {
            return raf.read() | raf.read() << 8 | raf.read() << 16 | raf.read() << 24;
        }
        return raf.read() << 24 | raf.read() << 16 | raf.read() << 8 | raf.read();
    }

    static {
        FAX_FILTERS.add(COSName.CCITTFAX_DECODE.getName());
        FAX_FILTERS.add(COSName.CCITTFAX_DECODE_ABBREVIATION.getName());
    }

    private class TiffWrapper
    extends InputStream {
        private int currentOffset;
        private byte[] tiffheader;
        private InputStream datastream;
        private final byte[] basicHeader = new byte[]{73, 73, 42, 0, 8, 0, 0, 0, 0, 0};
        private int additionalOffset;

        private TiffWrapper(InputStream rawstream, COSDictionary options) {
            this.buildHeader(options);
            this.currentOffset = 0;
            this.datastream = rawstream;
        }

        public boolean markSupported() {
            return false;
        }

        public void reset() throws IOException {
            throw new IOException("reset not supported");
        }

        public int read() throws IOException {
            if (this.currentOffset < this.tiffheader.length) {
                return this.tiffheader[this.currentOffset++];
            }
            return this.datastream.read();
        }

        public int read(byte[] data) throws IOException {
            if (this.currentOffset < this.tiffheader.length) {
                int length = Math.min(this.tiffheader.length - this.currentOffset, data.length);
                if (length > 0) {
                    System.arraycopy(this.tiffheader, this.currentOffset, data, 0, length);
                }
                this.currentOffset += length;
                return length;
            }
            return this.datastream.read(data);
        }

        public int read(byte[] data, int off, int len) throws IOException {
            if (this.currentOffset < this.tiffheader.length) {
                int length = Math.min(this.tiffheader.length - this.currentOffset, len);
                if (length > 0) {
                    System.arraycopy(this.tiffheader, this.currentOffset, data, off, length);
                }
                this.currentOffset += length;
                return length;
            }
            return this.datastream.read(data, off, len);
        }

        public long skip(long n) throws IOException {
            if (this.currentOffset < this.tiffheader.length) {
                long length = Math.min((long)(this.tiffheader.length - this.currentOffset), n);
                this.currentOffset = (int)((long)this.currentOffset + length);
                return length;
            }
            return this.datastream.skip(n);
        }

        private void buildHeader(COSDictionary options) {
            int numOfTags = 10;
            int maxAdditionalData = 24;
            this.tiffheader = new byte[158];
            Arrays.fill(this.tiffheader, (byte)0);
            System.arraycopy(this.basicHeader, 0, this.tiffheader, 0, this.basicHeader.length);
            this.additionalOffset = 134;
            short cols = 1728;
            short rows = 0;
            short blackis1 = 0;
            int comptype = 3;
            long t4options = 0L;
            COSBase dicOrArrayParms = options.getDictionaryObject("DecodeParms");
            COSDictionary decodeParms = null;
            if (dicOrArrayParms instanceof COSDictionary) {
                decodeParms = (COSDictionary)dicOrArrayParms;
            } else {
                COSArray parmsArray = (COSArray)dicOrArrayParms;
                if (parmsArray.size() == 1) {
                    decodeParms = (COSDictionary)parmsArray.getObject(0);
                } else {
                    for (int i = 0; i < parmsArray.size() && decodeParms == null; ++i) {
                        COSDictionary dic = (COSDictionary)parmsArray.getObject(i);
                        if (dic == null || dic.getDictionaryObject("Columns") == null && dic.getDictionaryObject("Rows") == null) continue;
                        decodeParms = dic;
                    }
                }
            }
            if (decodeParms != null) {
                int k;
                cols = (short)decodeParms.getInt("Columns", (int)cols);
                rows = (short)decodeParms.getInt("Rows", (int)rows);
                if (decodeParms.getBoolean("BlackIs1", false)) {
                    blackis1 = 1;
                }
                if ((k = decodeParms.getInt("K")) < 0) {
                    comptype = 4;
                }
                if (k > 0) {
                    comptype = 3;
                    t4options = 1L;
                }
            }
            if (rows == 0) {
                rows = (short)options.getInt("Height", (int)rows);
            }
            this.addTag(256, cols);
            this.addTag(257, rows);
            this.addTag(259, (short)comptype);
            this.addTag(262, blackis1);
            this.addTag(273, this.tiffheader.length);
            this.addTag(279, options.getInt("Length"));
            this.addTag(282, 300L, 1L);
            this.addTag(283, 300L, 1L);
            if (comptype == 3) {
                this.addTag(292, t4options);
            }
            this.addTag(305, "PDFBOX");
        }

        private void addTag(int tag, long value) {
            byte count = this.tiffheader[8] = (byte)(this.tiffheader[8] + 1);
            int offset = (count - 1) * 12 + 10;
            this.tiffheader[offset] = (byte)(tag & 0xFF);
            this.tiffheader[offset + 1] = (byte)(tag >> 8 & 0xFF);
            this.tiffheader[offset + 2] = 4;
            this.tiffheader[offset + 4] = 1;
            this.tiffheader[offset + 8] = (byte)(value & 0xFFL);
            this.tiffheader[offset + 9] = (byte)(value >> 8 & 0xFFL);
            this.tiffheader[offset + 10] = (byte)(value >> 16 & 0xFFL);
            this.tiffheader[offset + 11] = (byte)(value >> 24 & 0xFFL);
        }

        private void addTag(int tag, short value) {
            byte count = this.tiffheader[8] = (byte)(this.tiffheader[8] + 1);
            int offset = (count - 1) * 12 + 10;
            this.tiffheader[offset] = (byte)(tag & 0xFF);
            this.tiffheader[offset + 1] = (byte)(tag >> 8 & 0xFF);
            this.tiffheader[offset + 2] = 3;
            this.tiffheader[offset + 4] = 1;
            this.tiffheader[offset + 8] = (byte)(value & 0xFF);
            this.tiffheader[offset + 9] = (byte)(value >> 8 & 0xFF);
        }

        private void addTag(int tag, String value) {
            byte count = this.tiffheader[8] = (byte)(this.tiffheader[8] + 1);
            int offset = (count - 1) * 12 + 10;
            this.tiffheader[offset] = (byte)(tag & 0xFF);
            this.tiffheader[offset + 1] = (byte)(tag >> 8 & 0xFF);
            this.tiffheader[offset + 2] = 2;
            this.tiffheader[offset + 4] = 1;
            this.tiffheader[offset + 8] = (byte)(this.additionalOffset & 0xFF);
            this.tiffheader[offset + 9] = (byte)(this.additionalOffset >> 8 & 0xFF);
            this.tiffheader[offset + 10] = (byte)(this.additionalOffset >> 16 & 0xFF);
            this.tiffheader[offset + 11] = (byte)(this.additionalOffset >> 24 & 0xFF);
            System.arraycopy(value.getBytes(), 0, this.tiffheader, this.additionalOffset, value.length());
            this.additionalOffset += value.length() + 1;
        }

        private void addTag(int tag, long numerator, long denominator) {
            byte count = this.tiffheader[8] = (byte)(this.tiffheader[8] + 1);
            int offset = (count - 1) * 12 + 10;
            this.tiffheader[offset] = (byte)(tag & 0xFF);
            this.tiffheader[offset + 1] = (byte)(tag >> 8 & 0xFF);
            this.tiffheader[offset + 2] = 5;
            this.tiffheader[offset + 4] = 1;
            this.tiffheader[offset + 8] = (byte)(this.additionalOffset & 0xFF);
            this.tiffheader[offset + 9] = (byte)(this.additionalOffset >> 8 & 0xFF);
            this.tiffheader[offset + 10] = (byte)(this.additionalOffset >> 16 & 0xFF);
            this.tiffheader[offset + 11] = (byte)(this.additionalOffset >> 24 & 0xFF);
            this.tiffheader[this.additionalOffset++] = (byte)(numerator & 0xFFL);
            this.tiffheader[this.additionalOffset++] = (byte)(numerator >> 8 & 0xFFL);
            this.tiffheader[this.additionalOffset++] = (byte)(numerator >> 16 & 0xFFL);
            this.tiffheader[this.additionalOffset++] = (byte)(numerator >> 24 & 0xFFL);
            this.tiffheader[this.additionalOffset++] = (byte)(denominator & 0xFFL);
            this.tiffheader[this.additionalOffset++] = (byte)(denominator >> 8 & 0xFFL);
            this.tiffheader[this.additionalOffset++] = (byte)(denominator >> 16 & 0xFFL);
            this.tiffheader[this.additionalOffset++] = (byte)(denominator >> 24 & 0xFFL);
        }
    }
}

