/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.xobject;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.predictor.PredictorAlgorithm;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;

public class PDPixelMap
extends PDXObjectImage {
    private static final Log log = LogFactory.getLog(PDPixelMap.class);
    private BufferedImage image = null;

    public PDPixelMap(PDStream pdStream) {
        super(pdStream, "png");
    }

    public BufferedImage getRGBImage() throws IOException {
        if (this.image != null) {
            return this.image;
        }
        try {
            ColorModel cm;
            int width = this.getWidth();
            int height = this.getHeight();
            int bpc = this.getBitsPerComponent();
            int predictor = this.getPredictor();
            List filters = this.getPDStream().getFilters();
            byte[] array = this.getPDStream().getByteArray();
            PDColorSpace colorspace = this.getColorSpace();
            if (colorspace == null) {
                log.error("getColorSpace() returned NULL.  Predictor = " + this.getPredictor());
                return null;
            }
            if (bpc == 1) {
                byte[] map = new byte[]{0, -1};
                cm = new IndexColorModel(1, 2, map, map, map, 1);
            } else {
                cm = colorspace.createColorModel(bpc);
            }
            log.info("ColorModel: " + cm.toString());
            WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
            DataBufferByte buffer = (DataBufferByte)raster.getDataBuffer();
            byte[] bufferData = buffer.getData();
            if (predictor < 10 || filters == null || !filters.contains(COSName.LZW_DECODE.getName()) && !filters.contains(COSName.FLATE_DECODE.getName())) {
                PredictorAlgorithm filter = PredictorAlgorithm.getFilter(predictor);
                filter.setWidth(width);
                filter.setHeight(height);
                filter.setBpp(bpc * 3 / 8);
                filter.decode(array, bufferData);
            } else {
                System.arraycopy(array, 0, bufferData, 0, array.length < bufferData.length ? array.length : bufferData.length);
            }
            this.image = new BufferedImage(cm, raster, false, null);
            return this.image;
        }
        catch (Exception exception) {
            log.error(exception, exception);
            return null;
        }
    }

    public void write2OutputStream(OutputStream out) throws IOException {
        this.getRGBImage();
        if (this.image != null) {
            ImageIO.write((RenderedImage)this.image, "png", out);
        }
    }

    public COSDictionary getDecodeParams() {
        COSBase decodeParms = this.getCOSStream().getDictionaryObject("DecodeParms");
        if (decodeParms != null) {
            if (decodeParms instanceof COSDictionary) {
                return (COSDictionary)decodeParms;
            }
            if (decodeParms instanceof COSArray) {
                return null;
            }
            return null;
        }
        return null;
    }

    public int getPredictor() {
        int i;
        COSDictionary decodeParms = this.getDecodeParams();
        if (decodeParms != null && (i = decodeParms.getInt("Predictor")) != -1) {
            return i;
        }
        return 1;
    }
}

