/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.xobject;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;

public class PDXObjectForm
extends PDXObject {
    public static final String SUB_TYPE = "Form";

    public PDXObjectForm(PDStream formStream) {
        super(formStream);
        this.getCOSStream().setName(COSName.SUBTYPE, SUB_TYPE);
    }

    public PDXObjectForm(COSStream formStream) {
        super(formStream);
        this.getCOSStream().setName(COSName.SUBTYPE, SUB_TYPE);
    }

    public int getFormType() {
        return this.getCOSStream().getInt("FormType", 1);
    }

    public void setFormType(int formType) {
        this.getCOSStream().setInt("FormType", formType);
    }

    public PDResources getResources() {
        PDResources retval = null;
        COSDictionary resources = (COSDictionary)this.getCOSStream().getDictionaryObject(COSName.RESOURCES);
        if (resources != null) {
            retval = new PDResources(resources);
        }
        return retval;
    }

    public void setResources(PDResources resources) {
        this.getCOSStream().setItem(COSName.RESOURCES, (COSObjectable)resources);
    }

    public PDRectangle getBBox() {
        PDRectangle retval = null;
        COSArray array = (COSArray)this.getCOSStream().getDictionaryObject(COSName.BBOX);
        if (array != null) {
            retval = new PDRectangle(array);
        }
        return retval;
    }

    public void setBBox(PDRectangle bbox) {
        if (bbox == null) {
            this.getCOSStream().removeItem(COSName.BBOX);
        } else {
            this.getCOSStream().setItem(COSName.BBOX, (COSBase)bbox.getCOSArray());
        }
    }
}

