/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.annotation;

import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.COSDictionaryMap;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;

public class PDAppearanceDictionary
implements COSObjectable {
    private COSDictionary dictionary;

    public PDAppearanceDictionary() {
        this.dictionary = new COSDictionary();
        this.dictionary.setItem(COSName.getPDFName("N"), (COSBase)new COSDictionary());
    }

    public PDAppearanceDictionary(COSDictionary dict) {
        this.dictionary = dict;
    }

    public COSDictionary getDictionary() {
        return this.dictionary;
    }

    public COSBase getCOSObject() {
        return this.dictionary;
    }

    public Map getNormalAppearance() {
        COSBase ap = this.dictionary.getDictionaryObject(COSName.getPDFName("N"));
        if (ap instanceof COSStream) {
            COSStream aux = (COSStream)ap;
            ap = new COSDictionary();
            ((COSDictionary)ap).setItem(COSName.getPDFName("default"), (COSBase)aux);
        }
        COSDictionary map = (COSDictionary)ap;
        HashMap<String, PDAppearanceStream> actuals = new HashMap<String, PDAppearanceStream>();
        COSDictionaryMap retval = new COSDictionaryMap(actuals, map);
        for (COSName asName : map.keyList()) {
            COSStream as = (COSStream)map.getDictionaryObject(asName);
            actuals.put(asName.getName(), new PDAppearanceStream(as));
        }
        return retval;
    }

    public void setNormalAppearance(Map appearanceMap) {
        this.dictionary.setItem(COSName.getPDFName("N"), (COSBase)COSDictionaryMap.convert(appearanceMap));
    }

    public void setNormalAppearance(PDAppearanceStream ap) {
        this.dictionary.setItem(COSName.getPDFName("N"), (COSBase)ap.getStream());
    }

    public Map getRolloverAppearance() {
        Map retval = null;
        COSBase ap = this.dictionary.getDictionaryObject(COSName.getPDFName("R"));
        if (ap == null) {
            retval = this.getNormalAppearance();
        } else {
            if (ap instanceof COSStream) {
                COSStream aux = (COSStream)ap;
                ap = new COSDictionary();
                ((COSDictionary)ap).setItem(COSName.getPDFName("default"), (COSBase)aux);
            }
            COSDictionary map = (COSDictionary)ap;
            HashMap<String, PDAppearanceStream> actuals = new HashMap<String, PDAppearanceStream>();
            retval = new COSDictionaryMap(actuals, map);
            for (COSName asName : map.keyList()) {
                COSStream as = (COSStream)map.getDictionaryObject(asName);
                actuals.put(asName.getName(), new PDAppearanceStream(as));
            }
        }
        return retval;
    }

    public void setRolloverAppearance(Map appearanceMap) {
        this.dictionary.setItem(COSName.getPDFName("R"), (COSBase)COSDictionaryMap.convert(appearanceMap));
    }

    public Map getDownAppearance() {
        Map retval = null;
        COSBase ap = this.dictionary.getDictionaryObject(COSName.getPDFName("D"));
        if (ap == null) {
            retval = this.getNormalAppearance();
        } else {
            if (ap instanceof COSStream) {
                COSStream aux = (COSStream)ap;
                ap = new COSDictionary();
                ((COSDictionary)ap).setItem(COSName.getPDFName("default"), (COSBase)aux);
            }
            COSDictionary map = (COSDictionary)ap;
            HashMap<String, PDAppearanceStream> actuals = new HashMap<String, PDAppearanceStream>();
            retval = new COSDictionaryMap(actuals, map);
            for (COSName asName : map.keyList()) {
                COSStream as = (COSStream)map.getDictionaryObject(asName);
                actuals.put(asName.getName(), new PDAppearanceStream(as));
            }
        }
        return retval;
    }

    public void setDownAppearance(Map appearanceMap) {
        this.dictionary.setItem(COSName.getPDFName("D"), (COSBase)COSDictionaryMap.convert(appearanceMap));
    }
}

