/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util.operator.pagedrawer;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.pdfviewer.PageDrawer;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDInlinedImage;
import org.apache.pdfbox.util.ImageParameters;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.PDFOperator;
import org.apache.pdfbox.util.operator.OperatorProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeginInlineImage
extends OperatorProcessor {
    private static final Log log = LogFactory.getLog(BeginInlineImage.class);

    @Override
    public void process(PDFOperator operator, List<COSBase> arguments) throws IOException {
        PageDrawer drawer = (PageDrawer)this.context;
        PDPage page = drawer.getPage();
        Dimension pageSize = drawer.getPageSize();
        Graphics2D graphics = drawer.getGraphics();
        ImageParameters params = operator.getImageParameters();
        PDInlinedImage image = new PDInlinedImage();
        image.setImageParameters(params);
        image.setImageData(operator.getImageData());
        BufferedImage awtImage = image.createImage(this.context.getColorSpaces());
        if (awtImage == null) {
            log.warn("BeginInlineImage.process(): createImage returned NULL");
            return;
        }
        int imageWidth = awtImage.getWidth();
        int imageHeight = awtImage.getHeight();
        double pageHeight = pageSize.getHeight();
        Matrix ctm = drawer.getGraphicsState().getCurrentTransformationMatrix();
        int pageRotation = page.findRotation();
        AffineTransform ctmAT = ctm.createAffineTransform();
        ctmAT.scale(1.0f / (float)imageWidth, 1.0f / (float)imageHeight);
        Matrix rotationMatrix = new Matrix();
        rotationMatrix.setFromAffineTransform(ctmAT);
        if (pageRotation == 0 || pageRotation == 180) {
            rotationMatrix.setValue(2, 1, (float)pageHeight - ctm.getYPosition() - ctm.getYScale());
        } else if (pageRotation == 90 || pageRotation == 270) {
            rotationMatrix.setValue(2, 0, ctm.getXPosition() - ctm.getYScale());
            rotationMatrix.setValue(2, 1, (float)pageHeight - ctm.getYPosition());
        }
        rotationMatrix.setValue(0, 1, -1.0f * rotationMatrix.getValue(0, 1));
        rotationMatrix.setValue(1, 0, -1.0f * rotationMatrix.getValue(1, 0));
        AffineTransform at = new AffineTransform(rotationMatrix.getValue(0, 0), rotationMatrix.getValue(0, 1), rotationMatrix.getValue(1, 0), rotationMatrix.getValue(1, 1), rotationMatrix.getValue(2, 0), rotationMatrix.getValue(2, 1));
        Shape clip = this.context.getGraphicsState().getCurrentClippingPath();
        if (clip == null) {
            clip = new Rectangle(pageSize);
        }
        graphics.setClip(clip);
        graphics.drawImage(awtImage, at, null);
    }
}

