/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParsingReader;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.SAXException;

public class Tika {
    private final Detector detector;
    private final Parser parser;

    public Tika(TikaConfig config) {
        this.detector = config.getMimeRepository();
        this.parser = new AutoDetectParser(config);
    }

    public Tika() {
        this(TikaConfig.getDefaultConfig());
    }

    public String detect(InputStream stream, Metadata metadata) throws IOException {
        if (stream == null || stream.markSupported()) {
            return this.detector.detect(stream, metadata).toString();
        }
        return this.detector.detect(new BufferedInputStream(stream), metadata).toString();
    }

    public String detect(InputStream stream) throws IOException {
        return this.detect(stream, new Metadata());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String detect(File file) throws FileNotFoundException, IOException {
        FileInputStream stream = new FileInputStream(file);
        try {
            String string = this.detect(stream, Tika.getFileMetadata(file));
            return string;
        }
        finally {
            ((InputStream)stream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String detect(URL url) throws IOException {
        InputStream stream = url.openStream();
        try {
            String string = this.detect(stream, Tika.getUrlMetadata(url));
            return string;
        }
        finally {
            stream.close();
        }
    }

    public String detect(String name) {
        Metadata metadata = new Metadata();
        metadata.set("resourceName", name);
        try {
            return this.detect(null, metadata);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IOException", e);
        }
    }

    public Reader parse(InputStream stream, Metadata metadata) throws IOException {
        ParseContext context = new ParseContext();
        context.set(Parser.class, this.parser);
        return new ParsingReader(this.parser, stream, metadata, context);
    }

    public Reader parse(InputStream stream) throws IOException {
        return this.parse(stream, new Metadata());
    }

    public Reader parse(File file) throws FileNotFoundException, IOException {
        return this.parse(new FileInputStream(file), Tika.getFileMetadata(file));
    }

    public Reader parse(URL url) throws IOException {
        return this.parse(url.openStream(), Tika.getUrlMetadata(url));
    }

    public String parseToString(InputStream stream, Metadata metadata) throws IOException, TikaException {
        try {
            BodyContentHandler handler = new BodyContentHandler();
            ParseContext context = new ParseContext();
            context.set(Parser.class, this.parser);
            this.parser.parse(stream, handler, metadata, context);
            String string = ((Object)handler).toString();
            return string;
        }
        catch (SAXException e) {
            throw new TikaException("Unexpected SAX processing failure", e);
        }
        finally {
            stream.close();
        }
    }

    public String parseToString(InputStream stream) throws IOException, TikaException {
        return this.parseToString(stream, new Metadata());
    }

    public String parseToString(File file) throws FileNotFoundException, IOException, TikaException {
        return this.parseToString(new FileInputStream(file), Tika.getFileMetadata(file));
    }

    public String parseToString(URL url) throws IOException, TikaException {
        return this.parseToString(url.openStream(), Tika.getUrlMetadata(url));
    }

    private static Metadata getFileMetadata(File file) {
        Metadata metadata = new Metadata();
        metadata.set("resourceName", file.getName());
        return metadata;
    }

    private static Metadata getUrlMetadata(URL url) {
        Metadata metadata = new Metadata();
        String path = url.getPath();
        int slash = path.lastIndexOf(47);
        if (slash + 1 < path.length()) {
            metadata.set("resourceName", path.substring(slash + 1));
        }
        return metadata;
    }
}

