/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MediaType {
    private static final Map<String, String> NO_PARAMETERS = new TreeMap<String, String>();
    private static final Pattern SPECIAL = Pattern.compile("[\\(\\)<>@,;:\\\\\"/\\[\\]\\?=]");
    private static final Pattern SPECIAL_OR_WHITESPACE = Pattern.compile("[\\(\\)<>@,;:\\\\\"/\\[\\]\\?=\\s]");
    private static final String VALID_MIMETYPE_CHARS = "[^\\c\\(\\)<>@,;:\\\\\"/\\[\\]\\?=\\s]";
    private static final String MIME_TYPE_PATTERN_STRING = "([^\\c\\(\\)<>@,;:\\\\\"/\\[\\]\\?=\\s]+)\\s*/\\s*([^\\c\\(\\)<>@,;:\\\\\"/\\[\\]\\?=\\s]+)";
    private static final Pattern CONTENT_TYPE_PATTERN = Pattern.compile("(?is)\\s*([^\\c\\(\\)<>@,;:\\\\\"/\\[\\]\\?=\\s]+)\\s*/\\s*([^\\c\\(\\)<>@,;:\\\\\"/\\[\\]\\?=\\s]+)\\s*($|;.*)");
    private static final Pattern CONTENT_TYPE_CHARSET_FIRST_PATTERN = Pattern.compile("(?i)\\s*(charset\\s*=\\s*[^\\c;\\s]+)\\s*;\\s*([^\\c\\(\\)<>@,;:\\\\\"/\\[\\]\\?=\\s]+)\\s*/\\s*([^\\c\\(\\)<>@,;:\\\\\"/\\[\\]\\?=\\s]+)");
    public static final MediaType OCTET_STREAM = new MediaType("application", "octet-stream", NO_PARAMETERS);
    public static final MediaType TEXT_PLAIN = new MediaType("text", "plain", NO_PARAMETERS);
    public static final MediaType APPLICATION_XML = new MediaType("application", "xml", NO_PARAMETERS);
    private final String type;
    private final String subtype;
    private final SortedMap<String, String> parameters;

    public static MediaType parse(String string) {
        String[] paramPieces;
        String params;
        String subtype;
        String type;
        if (string == null) {
            return null;
        }
        Matcher m = CONTENT_TYPE_PATTERN.matcher(string);
        if (m.matches()) {
            type = m.group(1);
            subtype = m.group(2);
            params = m.group(3);
        } else {
            m = CONTENT_TYPE_CHARSET_FIRST_PATTERN.matcher(string);
            if (m.matches()) {
                params = m.group(1);
                type = m.group(2);
                subtype = m.group(3);
            } else {
                return null;
            }
        }
        MediaType result = new MediaType(type, subtype);
        for (String paramPiece : paramPieces = params.split(";")) {
            String key;
            String[] keyValue = paramPiece.split("=");
            if (keyValue.length != 2 || (key = keyValue[0].trim()).length() <= 0) continue;
            result.parameters.put(key, keyValue[1].trim());
        }
        return result;
    }

    public MediaType(String type, String subtype, Map<String, String> parameters) {
        this.type = type.trim().toLowerCase();
        this.subtype = subtype.trim().toLowerCase();
        this.parameters = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            this.parameters.put(entry.getKey().trim().toLowerCase(), entry.getValue());
        }
    }

    public MediaType(String type, String subtype) {
        this(type, subtype, NO_PARAMETERS);
    }

    private static Map<String, String> union(Map<String, String> a, Map<String, String> b) {
        if (a.isEmpty()) {
            return b;
        }
        if (b.isEmpty()) {
            return a;
        }
        HashMap<String, String> union = new HashMap<String, String>();
        union.putAll(a);
        union.putAll(b);
        return union;
    }

    public MediaType(MediaType type, Map<String, String> parameters) {
        this(type.type, type.subtype, MediaType.union(type.parameters, parameters));
    }

    public MediaType getBaseType() {
        if (this.parameters.isEmpty()) {
            return this;
        }
        return new MediaType(this.type, this.subtype);
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public boolean isSpecializationOf(MediaType that) {
        if (OCTET_STREAM.equals(that)) {
            return true;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        if (!this.parameters.entrySet().containsAll(that.parameters.entrySet())) {
            return false;
        }
        if (TEXT_PLAIN.equals(that.getBaseType())) {
            return true;
        }
        if (APPLICATION_XML.equals(that.getBaseType()) && this.subtype.endsWith("+xml")) {
            return true;
        }
        return this.subtype.equals(that.subtype);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.type);
        builder.append('/');
        builder.append(this.subtype);
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            builder.append("; ");
            builder.append(entry.getKey());
            builder.append("=");
            String value = entry.getValue();
            if (SPECIAL_OR_WHITESPACE.matcher(value).find()) {
                builder.append('\"');
                builder.append(SPECIAL.matcher(value).replaceAll("\\\\$0"));
                builder.append('\"');
                continue;
            }
            builder.append(value);
        }
        return builder.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof MediaType) {
            MediaType that = (MediaType)object;
            return this.type.equals(that.type) && this.subtype.equals(that.subtype) && this.parameters.equals(that.parameters);
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.type.hashCode();
        hash = hash * 31 + this.subtype.hashCode();
        hash = hash * 31 + this.parameters.hashCode();
        return hash;
    }
}

