/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.awt.Point;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.HyperlinkRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.RKRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.TextObjectRecord;
import org.apache.poi.hssf.record.UnicodeString;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.tika.parser.microsoft.Cell;
import org.apache.tika.parser.microsoft.LinkedCell;
import org.apache.tika.parser.microsoft.NumberCell;
import org.apache.tika.parser.microsoft.TextCell;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

public class ExcelExtractor {
    private boolean listenForAllRecords = false;

    public boolean isListenForAllRecords() {
        return this.listenForAllRecords;
    }

    public void setListenForAllRecords(boolean listenForAllRecords) {
        this.listenForAllRecords = listenForAllRecords;
    }

    protected void parse(POIFSFileSystem filesystem, XHTMLContentHandler xhtml, Locale locale) throws IOException, SAXException {
        TikaHSSFListener listener = new TikaHSSFListener(xhtml, locale);
        listener.processFile(filesystem, this.isListenForAllRecords());
        listener.throwStoredException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PointComparator
    implements Comparator<Point> {
        private PointComparator() {
        }

        @Override
        public int compare(Point a, Point b) {
            int diff = a.y - b.y;
            if (diff == 0) {
                diff = a.x - b.x;
            }
            return diff;
        }
    }

    private static class TikaHSSFListener
    implements HSSFListener {
        private final XHTMLContentHandler handler;
        private SAXException exception = null;
        private SSTRecord sstRecord;
        private FormatTrackingHSSFListener formatListener;
        private List<String> sheetNames = new ArrayList<String>();
        private short currentSheetIndex;
        private SortedMap<Point, Cell> currentSheet = null;
        private final NumberFormat format;

        private TikaHSSFListener(XHTMLContentHandler handler, Locale locale) {
            this.handler = handler;
            this.format = NumberFormat.getInstance(locale);
        }

        public void processFile(POIFSFileSystem filesystem, boolean listenForAllRecords) throws IOException, SAXException {
            this.formatListener = new FormatTrackingHSSFListener(this);
            HSSFRequest hssfRequest = new HSSFRequest();
            if (listenForAllRecords) {
                hssfRequest.addListenerForAllRecords(this.formatListener);
            } else {
                hssfRequest.addListener(this.formatListener, (short)2057);
                hssfRequest.addListener(this.formatListener, (short)10);
                hssfRequest.addListener(this.formatListener, (short)34);
                hssfRequest.addListener(this.formatListener, (short)140);
                hssfRequest.addListener(this.formatListener, (short)133);
                hssfRequest.addListener(this.formatListener, (short)252);
                hssfRequest.addListener(this.formatListener, (short)6);
                hssfRequest.addListener(this.formatListener, (short)516);
                hssfRequest.addListener(this.formatListener, (short)253);
                hssfRequest.addListener(this.formatListener, (short)515);
                hssfRequest.addListener(this.formatListener, (short)638);
                hssfRequest.addListener(this.formatListener, (short)440);
                hssfRequest.addListener(this.formatListener, (short)438);
                hssfRequest.addListener(this.formatListener, (short)1054);
                hssfRequest.addListener(this.formatListener, (short)224);
            }
            DocumentInputStream documentInputStream = filesystem.createDocumentInputStream("Workbook");
            HSSFEventFactory eventFactory = new HSSFEventFactory();
            eventFactory.processEvents(hssfRequest, documentInputStream);
        }

        public void processRecord(Record record) {
            if (this.exception == null) {
                try {
                    this.internalProcessRecord(record);
                }
                catch (SAXException e) {
                    this.exception = e;
                }
            }
        }

        public void throwStoredException() throws SAXException {
            if (this.exception != null) {
                throw this.exception;
            }
        }

        private void internalProcessRecord(Record record) throws SAXException {
            switch (record.getSid()) {
                case 2057: {
                    BOFRecord bof = (BOFRecord)record;
                    if (bof.getType() == 5) {
                        this.currentSheetIndex = (short)-1;
                        break;
                    }
                    if (bof.getType() != 16) break;
                    this.currentSheetIndex = (short)(this.currentSheetIndex + 1);
                    this.currentSheet = new TreeMap<Point, Cell>(new PointComparator());
                    break;
                }
                case 10: {
                    if (this.currentSheet != null) {
                        this.processSheet();
                    }
                    this.currentSheet = null;
                    break;
                }
                case 133: {
                    BoundSheetRecord boundSheetRecord = (BoundSheetRecord)record;
                    this.sheetNames.add(boundSheetRecord.getSheetname());
                    break;
                }
                case 252: {
                    this.sstRecord = (SSTRecord)record;
                    break;
                }
                case 6: {
                    FormulaRecord formula = (FormulaRecord)record;
                    this.addCell(record, new NumberCell(formula.getValue(), this.format));
                    break;
                }
                case 516: {
                    LabelRecord label = (LabelRecord)record;
                    this.addTextCell(record, label.getValue());
                    break;
                }
                case 253: {
                    LabelSSTRecord sst = (LabelSSTRecord)record;
                    UnicodeString unicode = this.sstRecord.getString(sst.getSSTIndex());
                    this.addTextCell(record, unicode.getString());
                    break;
                }
                case 515: {
                    NumberRecord number = (NumberRecord)record;
                    this.addTextCell(record, this.formatListener.formatNumberDateCell(number));
                    break;
                }
                case 638: {
                    RKRecord rk = (RKRecord)record;
                    this.addCell(record, new NumberCell(rk.getRKNumber(), this.format));
                    break;
                }
                case 440: {
                    HyperlinkRecord link;
                    Point point;
                    Cell cell;
                    if (this.currentSheet == null || (cell = (Cell)this.currentSheet.get(point = new Point((link = (HyperlinkRecord)record).getFirstColumn(), link.getFirstRow()))) == null) break;
                    this.addCell(record, new LinkedCell(cell, link.getAddress()));
                    break;
                }
                case 438: {
                    TextObjectRecord tor = (TextObjectRecord)record;
                    this.addTextCell(record, tor.getStr().getString());
                }
            }
        }

        private void addCell(Record record, Cell cell) throws SAXException {
            if (cell != null) {
                if (this.currentSheet != null && record instanceof CellValueRecordInterface) {
                    CellValueRecordInterface value = (CellValueRecordInterface)((Object)record);
                    Point point = new Point(value.getColumn(), value.getRow());
                    this.currentSheet.put(point, cell);
                } else {
                    this.handler.startElement("div", "class", "outside");
                    cell.render(this.handler);
                    this.handler.endElement("div");
                }
            }
        }

        private void addTextCell(Record record, String text) throws SAXException {
            if (text != null && (text = text.trim()).length() > 0) {
                this.addCell(record, new TextCell(text));
            }
        }

        private void processSheet() throws SAXException {
            this.handler.startElement("div", "class", "page");
            if (this.currentSheetIndex < this.sheetNames.size()) {
                this.handler.element("h1", this.sheetNames.get(this.currentSheetIndex));
            }
            this.handler.startElement("table");
            this.handler.startElement("tbody");
            int currentRow = 0;
            int currentColumn = 0;
            this.handler.startElement("tr");
            this.handler.startElement("td");
            for (Map.Entry<Point, Cell> entry : this.currentSheet.entrySet()) {
                while (currentRow < entry.getKey().y) {
                    this.handler.endElement("td");
                    this.handler.endElement("tr");
                    this.handler.startElement("tr");
                    this.handler.startElement("td");
                    ++currentRow;
                    currentColumn = 0;
                }
                while (currentColumn < entry.getKey().x) {
                    this.handler.endElement("td");
                    this.handler.startElement("td");
                    ++currentColumn;
                }
                entry.getValue().render(this.handler);
            }
            this.handler.endElement("td");
            this.handler.endElement("tr");
            this.handler.endElement("tbody");
            this.handler.endElement("table");
            this.handler.endElement("div");
        }
    }
}

