/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.OfflineContentHandler;
import org.apache.tika.sax.TextContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser
implements Parser {
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        if (metadata.get("Content-Type") == null) {
            metadata.set("Content-Type", "application/xml");
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        xhtml.startElement("p");
        this.getSAXParser(context).parse((InputStream)new CloseShieldInputStream(stream), (DefaultHandler)new OfflineContentHandler(this.getContentHandler(handler, metadata)));
        xhtml.endElement("p");
        xhtml.endDocument();
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, handler, metadata, new ParseContext());
    }

    protected ContentHandler getContentHandler(ContentHandler handler, Metadata metadata) {
        return new TextContentHandler(handler);
    }

    private SAXParser getSAXParser(ParseContext context) throws TikaException {
        SAXParser parser = context.get(SAXParser.class);
        if (parser instanceof SAXParser) {
            return parser;
        }
        try {
            return this.getSAXParserFactory(context).newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new TikaException("Unable to configure a SAX parser", e);
        }
        catch (SAXException e) {
            throw new TikaException("Unable to create a SAX parser", e);
        }
    }

    private SAXParserFactory getSAXParserFactory(ParseContext context) {
        SAXParserFactory factory = context.get(SAXParserFactory.class);
        if (factory != null) {
            return factory;
        }
        return this.getDefaultSAXParserFactory();
    }

    private SAXParserFactory getDefaultSAXParserFactory() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException e) {
        }
        catch (SAXNotSupportedException e) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            // empty catch block
        }
        return factory;
    }
}

