/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io.nio;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.io.Connection;
import org.mortbay.io.EndPoint;
import org.mortbay.io.nio.SelectChannelEndPoint;
import org.mortbay.log.Log;
import org.mortbay.thread.Timeout;

public abstract class SelectorManager
extends AbstractLifeCycle {
    private static final int __JVMBUG_THRESHHOLD = Integer.getInteger("org.mortbay.io.nio.JVMBUG_THRESHHOLD", 512);
    private static final int __MONITOR_PERIOD = Integer.getInteger("org.mortbay.io.nio.MONITOR_PERIOD", 1000);
    private static final int __MAX_SELECTS = Integer.getInteger("org.mortbay.io.nio.MAX_SELECTS", 15000);
    private static final int __BUSY_PAUSE = Integer.getInteger("org.mortbay.io.nio.BUSY_PAUSE", 50);
    private static final int __BUSY_KEY = Integer.getInteger("org.mortbay.io.nio.BUSY_KEY", -1);
    private boolean _delaySelectKeyUpdate = true;
    private long _maxIdleTime;
    private long _lowResourcesConnections;
    private long _lowResourcesMaxIdleTime;
    private transient SelectSet[] _selectSet;
    private int _selectSets = 1;
    private volatile int _set;

    public void setMaxIdleTime(long maxIdleTime) {
        this._maxIdleTime = maxIdleTime;
    }

    public void setSelectSets(int selectSets) {
        long lrc = this._lowResourcesConnections * (long)this._selectSets;
        this._selectSets = selectSets;
        this._lowResourcesConnections = lrc / (long)this._selectSets;
    }

    public long getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public int getSelectSets() {
        return this._selectSets;
    }

    public boolean isDelaySelectKeyUpdate() {
        return this._delaySelectKeyUpdate;
    }

    public void register(SocketChannel channel, Object att) throws IOException {
        int s = this._set++;
        s %= this._selectSets;
        SelectSet[] sets = this._selectSet;
        if (sets != null) {
            SelectSet set = sets[s];
            set.addChange(channel, att);
            set.wakeup();
        }
    }

    public void register(ServerSocketChannel acceptChannel) throws IOException {
        int s = this._set++;
        SelectSet set = this._selectSet[s %= this._selectSets];
        set.addChange(acceptChannel);
        set.wakeup();
    }

    public long getLowResourcesConnections() {
        return this._lowResourcesConnections * (long)this._selectSets;
    }

    public void setLowResourcesConnections(long lowResourcesConnections) {
        this._lowResourcesConnections = (lowResourcesConnections + (long)this._selectSets - 1L) / (long)this._selectSets;
    }

    public long getLowResourcesMaxIdleTime() {
        return this._lowResourcesMaxIdleTime;
    }

    public void setLowResourcesMaxIdleTime(long lowResourcesMaxIdleTime) {
        this._lowResourcesMaxIdleTime = lowResourcesMaxIdleTime;
    }

    public void doSelect(int acceptorID) throws IOException {
        SelectSet[] sets = this._selectSet;
        if (sets != null && sets.length > acceptorID && sets[acceptorID] != null) {
            sets[acceptorID].doSelect();
        }
    }

    public void setDelaySelectKeyUpdate(boolean delaySelectKeyUpdate) {
        this._delaySelectKeyUpdate = delaySelectKeyUpdate;
    }

    protected abstract SocketChannel acceptChannel(SelectionKey var1) throws IOException;

    public abstract boolean dispatch(Runnable var1) throws IOException;

    protected void doStart() throws Exception {
        this._selectSet = new SelectSet[this._selectSets];
        for (int i = 0; i < this._selectSet.length; ++i) {
            this._selectSet[i] = new SelectSet(i);
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        SelectSet[] sets = this._selectSet;
        this._selectSet = null;
        if (sets != null) {
            for (int i = 0; i < sets.length; ++i) {
                SelectSet set = sets[i];
                if (set == null) continue;
                set.stop();
            }
        }
        super.doStop();
    }

    protected abstract void endPointClosed(SelectChannelEndPoint var1);

    protected abstract void endPointOpened(SelectChannelEndPoint var1);

    protected abstract Connection newConnection(SocketChannel var1, SelectChannelEndPoint var2);

    protected abstract SelectChannelEndPoint newEndPoint(SocketChannel var1, SelectSet var2, SelectionKey var3) throws IOException;

    protected void connectionFailed(SocketChannel channel, Throwable ex, Object attachment) {
        Log.warn(ex);
    }

    private static interface ChangeTask {
        public void run();
    }

    private static class ChangeSelectableChannel {
        final SelectableChannel _channel;
        final Object _attachment;

        public ChangeSelectableChannel(SelectableChannel channel, Object attachment) {
            this._channel = channel;
            this._attachment = attachment;
        }
    }

    public class SelectSet {
        private transient int _change;
        private transient List[] _changes;
        private transient Timeout _idleTimeout;
        private transient int _nextSet;
        private transient Timeout _retryTimeout;
        private transient Selector _selector;
        private transient int _setID;
        private volatile boolean _selecting;
        private transient int _jvmBug;
        private int _selects;
        private long _monitorStart;
        private long _monitorNext;
        private boolean _pausing;
        private SelectionKey _busyKey;
        private int _busyKeyCount;
        private long _log;
        private int _paused;
        private int _jvmFix0;
        private int _jvmFix1;
        private int _jvmFix2;

        SelectSet(int acceptorID) throws Exception {
            this._setID = acceptorID;
            this._idleTimeout = new Timeout(this);
            this._idleTimeout.setDuration(SelectorManager.this.getMaxIdleTime());
            this._retryTimeout = new Timeout(this);
            this._retryTimeout.setDuration(0L);
            this._selector = Selector.open();
            this._changes = new ArrayList[]{new ArrayList(), new ArrayList()};
            this._change = 0;
            this._monitorStart = System.currentTimeMillis();
            this._monitorNext = this._monitorStart + (long)__MONITOR_PERIOD;
            this._log = this._monitorStart + 60000L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChange(Object point) {
            List[] listArray = this._changes;
            synchronized (this._changes) {
                this._changes[this._change].add(point);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        public void addChange(SelectableChannel channel, Object att) {
            if (att == null) {
                this.addChange(channel);
            } else if (att instanceof EndPoint) {
                this.addChange(att);
            } else {
                this.addChange(new ChangeSelectableChannel(channel, att));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelIdle(Timeout.Task task) {
            SelectSet selectSet = this;
            synchronized (selectSet) {
                task.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void doSelect() throws IOException {
            Iterator<SelectionKey> iterator;
            Selector new_selector;
            block76: {
                SelectionKey key = null;
                try {
                    try {
                        SelectChannelEndPoint endpoint;
                        long now;
                        Selector selector;
                        block83: {
                            block82: {
                                block79: {
                                    block77: {
                                        SelectionKey busy;
                                        block81: {
                                            block80: {
                                                int selected;
                                                block78: {
                                                    List[] listArray = this._changes;
                                                    // MONITORENTER : this._changes
                                                    List changes = this._changes[this._change];
                                                    this._change = this._change == 0 ? 1 : 0;
                                                    this._selecting = true;
                                                    selector = this._selector;
                                                    // MONITOREXIT : listArray
                                                    for (int i = 0; i < changes.size(); ++i) {
                                                        try {
                                                            AbstractSelectableChannel channel;
                                                            Object o = changes.get(i);
                                                            if (o instanceof EndPoint) {
                                                                SelectChannelEndPoint endpoint2 = (SelectChannelEndPoint)o;
                                                                endpoint2.doUpdateKey();
                                                                continue;
                                                            }
                                                            if (o instanceof Runnable) {
                                                                SelectorManager.this.dispatch((Runnable)o);
                                                                continue;
                                                            }
                                                            if (o instanceof ChangeSelectableChannel) {
                                                                ChangeSelectableChannel asc = (ChangeSelectableChannel)o;
                                                                SelectableChannel channel2 = asc._channel;
                                                                Object att = asc._attachment;
                                                                if (channel2 instanceof SocketChannel && ((SocketChannel)channel2).isConnected()) {
                                                                    key = channel2.register(selector, 1, att);
                                                                    SelectChannelEndPoint endpoint3 = SelectorManager.this.newEndPoint((SocketChannel)channel2, this, key);
                                                                    key.attach(endpoint3);
                                                                    endpoint3.dispatch();
                                                                    continue;
                                                                }
                                                                if (!channel2.isOpen()) continue;
                                                                channel2.register(selector, 8, att);
                                                                continue;
                                                            }
                                                            if (o instanceof SocketChannel) {
                                                                channel = (SocketChannel)o;
                                                                if (((SocketChannel)channel).isConnected()) {
                                                                    key = channel.register(selector, 1, null);
                                                                    SelectChannelEndPoint endpoint4 = SelectorManager.this.newEndPoint((SocketChannel)channel, this, key);
                                                                    key.attach(endpoint4);
                                                                    endpoint4.dispatch();
                                                                    continue;
                                                                }
                                                                if (!channel.isOpen()) continue;
                                                                channel.register(selector, 8, null);
                                                                continue;
                                                            }
                                                            if (o instanceof ServerSocketChannel) {
                                                                channel = (ServerSocketChannel)o;
                                                                channel.register(this.getSelector(), 16);
                                                                continue;
                                                            }
                                                            if (!(o instanceof ChangeTask)) throw new IllegalArgumentException(o.toString());
                                                            ((ChangeTask)o).run();
                                                            continue;
                                                        }
                                                        catch (Exception e) {
                                                            if (SelectorManager.this.isRunning()) {
                                                                Log.warn(e);
                                                                continue;
                                                            }
                                                            Log.debug(e);
                                                        }
                                                    }
                                                    changes.clear();
                                                    long idle_next = 0L;
                                                    long retry_next = 0L;
                                                    now = System.currentTimeMillis();
                                                    SelectSet selectSet = this;
                                                    // MONITORENTER : selectSet
                                                    this._idleTimeout.setNow(now);
                                                    this._retryTimeout.setNow(now);
                                                    if (SelectorManager.this._lowResourcesConnections > 0L && (long)selector.keys().size() > SelectorManager.this._lowResourcesConnections) {
                                                        this._idleTimeout.setDuration(SelectorManager.this._lowResourcesMaxIdleTime);
                                                    } else {
                                                        this._idleTimeout.setDuration(SelectorManager.this._maxIdleTime);
                                                    }
                                                    idle_next = this._idleTimeout.getTimeToNext();
                                                    retry_next = this._retryTimeout.getTimeToNext();
                                                    // MONITOREXIT : selectSet
                                                    long wait = 1000L;
                                                    if (idle_next >= 0L && wait > idle_next) {
                                                        wait = idle_next;
                                                    }
                                                    if (wait > 0L && retry_next >= 0L && wait > retry_next) {
                                                        wait = retry_next;
                                                    }
                                                    if (wait <= 2L) break block77;
                                                    if (this._pausing) {
                                                        try {
                                                            Thread.sleep(__BUSY_PAUSE);
                                                        }
                                                        catch (InterruptedException e) {
                                                            Log.ignore(e);
                                                        }
                                                    }
                                                    long before = now;
                                                    selected = selector.select(wait);
                                                    now = System.currentTimeMillis();
                                                    this._idleTimeout.setNow(now);
                                                    this._retryTimeout.setNow(now);
                                                    ++this._selects;
                                                    if (now > this._monitorNext) {
                                                        this._selects = (int)((long)(this._selects * __MONITOR_PERIOD) / (now - this._monitorStart));
                                                        boolean bl = this._pausing = this._selects > __MAX_SELECTS;
                                                        if (this._pausing) {
                                                            ++this._paused;
                                                        }
                                                        this._selects = 0;
                                                        this._jvmBug = 0;
                                                        this._monitorStart = now;
                                                        this._monitorNext = now + (long)__MONITOR_PERIOD;
                                                    }
                                                    if (now > this._log) {
                                                        if (this._paused > 0) {
                                                            Log.info(this + " Busy selector - injecting delay " + this._paused + " times");
                                                        }
                                                        if (this._jvmFix2 > 0) {
                                                            Log.info(this + " JVM BUG(s) - injecting delay" + this._jvmFix2 + " times");
                                                        }
                                                        if (this._jvmFix1 > 0) {
                                                            Log.info(this + " JVM BUG(s) - recreating selector " + this._jvmFix1 + " times, canceled keys " + this._jvmFix0 + " times");
                                                        } else if (Log.isDebugEnabled() && this._jvmFix0 > 0) {
                                                            Log.info(this + " JVM BUG(s) - canceled keys " + this._jvmFix0 + " times");
                                                        }
                                                        this._paused = 0;
                                                        this._jvmFix2 = 0;
                                                        this._jvmFix1 = 0;
                                                        this._jvmFix0 = 0;
                                                        this._log = now + 60000L;
                                                    }
                                                    if (selected != 0 || wait <= 10L || now - before >= wait / 2L) break block78;
                                                    ++this._jvmBug;
                                                    if (this._jvmBug > __JVMBUG_THRESHHOLD) {
                                                        try {
                                                            if (this._jvmBug == __JVMBUG_THRESHHOLD + 1) {
                                                                ++this._jvmFix2;
                                                            }
                                                            Thread.sleep(__BUSY_PAUSE);
                                                        }
                                                        catch (InterruptedException e) {
                                                            Log.ignore(e);
                                                        }
                                                        break block79;
                                                    } else {
                                                        if (this._jvmBug == __JVMBUG_THRESHHOLD) {
                                                            SelectSet e = this;
                                                            // MONITORENTER : e
                                                            ++this._jvmFix1;
                                                            new_selector = Selector.open();
                                                            iterator = this._selector.keys().iterator();
                                                            break block76;
                                                        }
                                                        if (this._jvmBug % 32 == 31) {
                                                            int cancelled = 0;
                                                            Iterator<SelectionKey> iter = selector.keys().iterator();
                                                            while (iter.hasNext()) {
                                                                SelectionKey k = iter.next();
                                                                if (!k.isValid() || k.interestOps() != 0) continue;
                                                                k.cancel();
                                                                ++cancelled;
                                                            }
                                                            if (cancelled > 0) {
                                                                ++this._jvmFix0;
                                                            }
                                                            Object var26_40 = null;
                                                            this._selecting = false;
                                                            return;
                                                        }
                                                    }
                                                    break block79;
                                                }
                                                if (__BUSY_KEY <= 0 || selected != 1 || this._selects <= __MAX_SELECTS) break block79;
                                                busy = selector.selectedKeys().iterator().next();
                                                if (busy != this._busyKey) break block80;
                                                if (++this._busyKeyCount > __BUSY_KEY && !(busy.channel() instanceof ServerSocketChannel)) {
                                                    endpoint = (SelectChannelEndPoint)busy.attachment();
                                                    Log.warn("Busy Key " + busy.channel() + " " + endpoint);
                                                    busy.cancel();
                                                    if (endpoint != null) {
                                                        endpoint.close();
                                                    }
                                                }
                                                break block81;
                                            }
                                            this._busyKeyCount = 0;
                                        }
                                        this._busyKey = busy;
                                        break block79;
                                    }
                                    selector.selectNow();
                                    ++this._selects;
                                }
                                if (this._selector == null) break block82;
                                if (selector.isOpen()) break block83;
                            }
                            Object var26_41 = null;
                            this._selecting = false;
                            return;
                        }
                        Iterator<SelectionKey> iter = selector.selectedKeys().iterator();
                        while (iter.hasNext()) {
                            key = iter.next();
                            try {
                                block85: {
                                    SocketChannel channel;
                                    Object att;
                                    block86: {
                                        block84: {
                                            if (!key.isValid()) {
                                                key.cancel();
                                                SelectChannelEndPoint endpoint5 = (SelectChannelEndPoint)key.attachment();
                                                if (endpoint5 == null) continue;
                                                endpoint5.doUpdateKey();
                                                continue;
                                            }
                                            att = key.attachment();
                                            if (!(att instanceof SelectChannelEndPoint)) break block84;
                                            SelectChannelEndPoint endpoint6 = (SelectChannelEndPoint)att;
                                            endpoint6.dispatch();
                                            break block85;
                                        }
                                        if (!key.isAcceptable()) break block86;
                                        channel = SelectorManager.this.acceptChannel(key);
                                        if (channel == null) continue;
                                        channel.configureBlocking(false);
                                        ++this._nextSet;
                                        this._nextSet %= SelectorManager.this._selectSet.length;
                                        if (this._nextSet == this._setID) {
                                            SelectionKey cKey = channel.register(SelectorManager.this._selectSet[this._nextSet].getSelector(), 1);
                                            endpoint = SelectorManager.this.newEndPoint(channel, SelectorManager.this._selectSet[this._nextSet], cKey);
                                            cKey.attach(endpoint);
                                            if (endpoint != null) {
                                                endpoint.dispatch();
                                            }
                                            break block85;
                                        } else {
                                            SelectorManager.this._selectSet[this._nextSet].addChange(channel);
                                            SelectorManager.this._selectSet[this._nextSet].wakeup();
                                        }
                                        break block85;
                                    }
                                    if (key.isConnectable()) {
                                        SelectChannelEndPoint endpoint7;
                                        Object var23_48;
                                        channel = (SocketChannel)key.channel();
                                        boolean connected = false;
                                        try {
                                            try {
                                                connected = channel.finishConnect();
                                            }
                                            catch (Exception e) {
                                                SelectorManager.this.connectionFailed(channel, e, att);
                                                var23_48 = null;
                                                if (connected) {
                                                    key.interestOps(1);
                                                    endpoint7 = SelectorManager.this.newEndPoint(channel, this, key);
                                                    key.attach(endpoint7);
                                                    endpoint7.dispatch();
                                                }
                                                key.cancel();
                                            }
                                            var23_48 = null;
                                            if (connected) {
                                                key.interestOps(1);
                                                endpoint7 = SelectorManager.this.newEndPoint(channel, this, key);
                                                key.attach(endpoint7);
                                                endpoint7.dispatch();
                                            }
                                            key.cancel();
                                        }
                                        catch (Throwable throwable) {
                                            var23_48 = null;
                                            if (connected) {
                                                key.interestOps(1);
                                                endpoint7 = SelectorManager.this.newEndPoint(channel, this, key);
                                                key.attach(endpoint7);
                                                endpoint7.dispatch();
                                                throw throwable;
                                            }
                                            key.cancel();
                                            throw throwable;
                                        }
                                    } else {
                                        channel = (SocketChannel)key.channel();
                                        SelectChannelEndPoint endpoint8 = SelectorManager.this.newEndPoint(channel, this, key);
                                        key.attach(endpoint8);
                                        if (key.isReadable()) {
                                            endpoint8.dispatch();
                                        }
                                    }
                                }
                                key = null;
                            }
                            catch (CancelledKeyException e) {
                                Log.ignore(e);
                            }
                            catch (Exception e) {
                                if (SelectorManager.this.isRunning()) {
                                    Log.warn(e);
                                } else {
                                    Log.ignore(e);
                                }
                                if (key == null || key.channel() instanceof ServerSocketChannel || !key.isValid()) continue;
                                key.interestOps(0);
                                key.cancel();
                            }
                        }
                        selector.selectedKeys().clear();
                        this._idleTimeout.tick(now);
                        this._retryTimeout.tick(now);
                    }
                    catch (CancelledKeyException e) {
                        Log.ignore(e);
                        Object var26_43 = null;
                        this._selecting = false;
                        return;
                    }
                    Object var26_42 = null;
                    this._selecting = false;
                    return;
                }
                catch (Throwable throwable) {
                    Object var26_44 = null;
                    this._selecting = false;
                    throw throwable;
                }
            }
            while (true) {
                if (!iterator.hasNext()) {
                    this._selector.close();
                    this._selector = new_selector;
                    // MONITOREXIT : e
                    Object var26_39 = null;
                    this._selecting = false;
                    return;
                }
                SelectionKey k = iterator.next();
                if (!k.isValid() || k.interestOps() == 0) continue;
                SelectableChannel channel = k.channel();
                Object attachment = k.attachment();
                if (attachment == null) {
                    this.addChange(channel);
                    continue;
                }
                this.addChange(channel, attachment);
            }
        }

        public SelectorManager getManager() {
            return SelectorManager.this;
        }

        public long getNow() {
            return this._idleTimeout.getNow();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleIdle(Timeout.Task task) {
            SelectSet selectSet = this;
            synchronized (selectSet) {
                if (this._idleTimeout.getDuration() <= 0L) {
                    return;
                }
                task.schedule(this._idleTimeout);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleTimeout(Timeout.Task task, long timeout) {
            SelectSet selectSet = this;
            synchronized (selectSet) {
                this._retryTimeout.schedule(task, timeout);
            }
        }

        public void wakeup() {
            Selector selector = this._selector;
            if (selector != null) {
                selector.wakeup();
            }
        }

        Selector getSelector() {
            return this._selector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() throws Exception {
            boolean selecting = true;
            while (selecting) {
                this.wakeup();
                selecting = this._selecting;
            }
            ArrayList<SelectionKey> keys = new ArrayList<SelectionKey>(this._selector.keys());
            Iterator<SelectionKey> iter = keys.iterator();
            while (iter.hasNext()) {
                Object att;
                SelectionKey key = iter.next();
                if (key == null || !((att = key.attachment()) instanceof EndPoint)) continue;
                EndPoint endpoint = (EndPoint)att;
                try {
                    endpoint.close();
                }
                catch (IOException e) {
                    Log.ignore(e);
                }
            }
            SelectSet selectSet = this;
            synchronized (selectSet) {
                selecting = this._selecting;
                while (selecting) {
                    this.wakeup();
                    selecting = this._selecting;
                }
                this._idleTimeout.cancelAll();
                this._retryTimeout.cancelAll();
                try {
                    if (this._selector != null) {
                        this._selector.close();
                    }
                }
                catch (IOException e) {
                    Log.ignore(e);
                }
                this._selector = null;
            }
        }
    }
}

