/*
 * Decompiled with CFR 0.152.
 */
package at.telekom.util.axis;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.axis.AxisFault;
import org.apache.axis.Handler;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;

public class AxisDebugLogHandler
extends BasicHandler
implements Handler {
    String reqMessage = null;
    String respMessage = null;
    private File baseDir = null;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    private static final long serialVersionUID = 1L;

    public void invoke(MessageContext arg0) throws AxisFault {
        Date now = new Date();
        Message m = arg0.getResponseMessage();
        if (m != null) {
            this.respMessage = m.getSOAPPartAsString();
            if (this.baseDir != null) {
                this.dumpToFile(String.valueOf(sdf.format(now)) + "_response", m.getSOAPPartAsBytes());
            }
            return;
        }
        this.respMessage = null;
        m = arg0.getRequestMessage();
        if (m != null) {
            this.reqMessage = m.getSOAPPartAsString();
            if (this.baseDir != null) {
                this.dumpToFile(String.valueOf(sdf.format(now)) + "_request", m.getSOAPPartAsBytes());
            }
        } else {
            this.reqMessage = null;
        }
    }

    public void init() {
        super.init();
    }

    public void onFault(MessageContext msgContext) {
        try {
            this.invoke(msgContext);
        }
        catch (AxisFault e) {
            System.err.println("Error while trying to log: " + (Object)((Object)e));
            e.printStackTrace();
        }
    }

    private void dumpToFile(String fName, byte[] partAsBytes) throws AxisFault {
        if (this.baseDir == null) {
            throw new IllegalArgumentException("Basedir not set in AxisDebugLogHandler!");
        }
        File f = new File(this.baseDir, fName);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f));
            bos.write(partAsBytes);
            bos.flush();
            bos.close();
        }
        catch (IOException e) {
            throw new AxisFault("Problem writing debug file.", (Throwable)e);
        }
    }

    public String getReqMessage() {
        return this.reqMessage;
    }

    public String getRespMessage() {
        return this.respMessage;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }
}

