/*
 * Decompiled with CFR 0.152.
 */
package at.telekom.util.axis;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import sun.misc.BASE64Encoder;

public class CertificateHelper {
    CertificateFactory factory = CertificateFactory.getInstance("X.509");

    public X509Certificate getCertificate(InputStream inStream) throws CertificateException {
        return (X509Certificate)this.factory.generateCertificate(inStream);
    }

    public X509Certificate getCertificate(byte[] inBytes) throws CertificateException, IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(inBytes);
        X509Certificate cert = this.getCertificate(bis);
        bis.close();
        return cert;
    }

    public X509Certificate getCertificate(File file) throws FileNotFoundException, CertificateException {
        FileInputStream fis = new FileInputStream(file);
        X509Certificate cert = this.getCertificate(fis);
        return cert;
    }

    public byte[] getEncodedCertificate(X509Certificate cert) throws CertificateEncodingException {
        return cert.getEncoded();
    }

    public boolean compareX509Certificates(X509Certificate cert1, X509Certificate cert2) throws CertificateEncodingException {
        byte[] data2;
        byte[] data1 = this.getEncodedCertificate(cert1);
        if (data1.length != (data2 = this.getEncodedCertificate(cert2)).length) {
            return false;
        }
        return Arrays.equals(data1, data2);
    }

    public KeyPair getPrivateKey(KeyStore keystore, String alias, char[] password) {
        try {
            Key key = keystore.getKey(alias, password);
            if (key instanceof PrivateKey) {
                Certificate cert = keystore.getCertificate(alias);
                PublicKey publicKey = cert.getPublicKey();
                return new KeyPair(publicKey, (PrivateKey)key);
            }
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return null;
    }

    public void printPrivateKey(String jksKeyStoreName, String aliasName, String pass) throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        char[] passPhrase = pass.toCharArray();
        BASE64Encoder myB64 = new BASE64Encoder();
        File certificateFile = new File(jksKeyStoreName);
        ks.load(new FileInputStream(certificateFile), passPhrase);
        KeyPair kp = this.getPrivateKey(ks, aliasName, passPhrase);
        PrivateKey privKey = kp.getPrivate();
        String b64 = myB64.encode(privKey.getEncoded());
        System.out.println("-----BEGIN PRIVATE KEY-----");
        System.out.println(b64);
        System.out.println("-----END PRIVATE KEY-----");
    }

    public void convertJKS2PKCS12(String jksKeyStoreFile, String pkcs12KeyStoreFile, String alias, String password) throws NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, KeyStoreException, UnrecoverableEntryException {
        KeyStore ks = KeyStore.getInstance("jks");
        KeyStore nks = KeyStore.getInstance("pkcs12");
        ks.load(new FileInputStream(jksKeyStoreFile), password.toCharArray());
        nks.load(null, password.toCharArray());
        KeyStore.PrivateKeyEntry pkEntry = (KeyStore.PrivateKeyEntry)ks.getEntry(alias, new KeyStore.PasswordProtection(password.toCharArray()));
        nks.setEntry(alias, pkEntry, new KeyStore.PasswordProtection(password.toCharArray()));
        FileOutputStream fos = new FileOutputStream(pkcs12KeyStoreFile);
        nks.store(fos, password.toCharArray());
        fos.close();
    }

    public static void main(String[] args) throws NoSuchAlgorithmException, CertificateException, FileNotFoundException, KeyStoreException, UnrecoverableEntryException, IOException {
        CertificateHelper helper = new CertificateHelper();
        helper.convertJKS2PKCS12("dist/certs/clientkey.jks", "dist/certs/clientkey.p12", "clientkey", "****");
        System.out.println("Conversion completed without exception.");
    }
}

