/*
 * Decompiled with CFR 0.152.
 */
package at.telekom.util.axis;

import at.telekom.util.axis.LoggingInputStream;
import at.telekom.util.axis.LoggingOutputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LoggingSocket
extends Socket {
    Socket wrappedSocket = null;
    File baseDir = null;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    ByteArrayOutputStream outgoing = null;
    ByteArrayOutputStream incoming = null;

    public LoggingSocket(Socket sock, String httpLogDir) {
        this.wrappedSocket = sock;
        this.baseDir = new File(httpLogDir);
        if (!(this.baseDir.exists() && this.baseDir.isDirectory() && this.baseDir.canWrite())) {
            throw new IllegalArgumentException("The Logdirectory configured (" + httpLogDir + ") is not a writeable directory.");
        }
        this.resetBuffers();
    }

    private void resetBuffers() {
        this.incoming = new ByteArrayOutputStream();
        this.outgoing = new ByteArrayOutputStream();
    }

    private OutputStream wrapOutput(OutputStream outputStream) {
        LoggingOutputStream los = new LoggingOutputStream(outputStream, this.outgoing);
        return los;
    }

    private InputStream wrapInput(InputStream inputStream) {
        LoggingInputStream lis = new LoggingInputStream(inputStream, this.incoming);
        return lis;
    }

    public void dumpLogs() {
        Date now = new Date();
        String fName = sdf.format(now);
        this.dumpToFile(String.valueOf(fName) + "_A_outgoing", this.outgoing.toByteArray());
        this.dumpToFile(String.valueOf(fName) + "_B_incoming", this.incoming.toByteArray());
        this.resetBuffers();
    }

    private void dumpToFile(String fName, byte[] partAsBytes) {
        if (this.baseDir == null) {
            throw new IllegalArgumentException("Basedir not set in AxisDebugLogHandler!");
        }
        File f = new File(this.baseDir, fName);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f));
            bos.write(partAsBytes);
            bos.flush();
            bos.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Problem writing debug file.", e);
        }
    }

    public void bind(SocketAddress bindpoint) throws IOException {
        this.wrappedSocket.bind(bindpoint);
    }

    public void close() throws IOException {
        this.wrappedSocket.close();
        this.dumpLogs();
    }

    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        this.wrappedSocket.connect(endpoint, timeout);
    }

    public void connect(SocketAddress endpoint) throws IOException {
        this.wrappedSocket.connect(endpoint);
    }

    public boolean equals(Object obj) {
        return this.wrappedSocket.equals(obj);
    }

    public SocketChannel getChannel() {
        return this.wrappedSocket.getChannel();
    }

    public InetAddress getInetAddress() {
        return this.wrappedSocket.getInetAddress();
    }

    public InputStream getInputStream() throws IOException {
        return this.wrapInput(this.wrappedSocket.getInputStream());
    }

    public boolean getKeepAlive() throws SocketException {
        return this.wrappedSocket.getKeepAlive();
    }

    public InetAddress getLocalAddress() {
        return this.wrappedSocket.getLocalAddress();
    }

    public int getLocalPort() {
        return this.wrappedSocket.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.wrappedSocket.getLocalSocketAddress();
    }

    public boolean getOOBInline() throws SocketException {
        return this.wrappedSocket.getOOBInline();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.wrapOutput(this.wrappedSocket.getOutputStream());
    }

    public int getPort() {
        return this.wrappedSocket.getPort();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.wrappedSocket.getReceiveBufferSize();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.wrappedSocket.getRemoteSocketAddress();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.wrappedSocket.getReuseAddress();
    }

    public int getSendBufferSize() throws SocketException {
        return this.wrappedSocket.getSendBufferSize();
    }

    public int getSoLinger() throws SocketException {
        return this.wrappedSocket.getSoLinger();
    }

    public int getSoTimeout() throws SocketException {
        return this.wrappedSocket.getSoTimeout();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.wrappedSocket.getTcpNoDelay();
    }

    public int getTrafficClass() throws SocketException {
        return this.wrappedSocket.getTrafficClass();
    }

    public int hashCode() {
        return this.wrappedSocket.hashCode();
    }

    public boolean isBound() {
        return this.wrappedSocket.isBound();
    }

    public boolean isClosed() {
        return this.wrappedSocket.isClosed();
    }

    public boolean isConnected() {
        return this.wrappedSocket.isConnected();
    }

    public boolean isInputShutdown() {
        return this.wrappedSocket.isInputShutdown();
    }

    public boolean isOutputShutdown() {
        return this.wrappedSocket.isOutputShutdown();
    }

    public void sendUrgentData(int data) throws IOException {
        this.wrappedSocket.sendUrgentData(data);
    }

    public void setKeepAlive(boolean on) throws SocketException {
        this.wrappedSocket.setKeepAlive(on);
    }

    public void setOOBInline(boolean on) throws SocketException {
        this.wrappedSocket.setOOBInline(on);
    }

    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.wrappedSocket.setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.wrappedSocket.setReceiveBufferSize(size);
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.wrappedSocket.setReuseAddress(on);
    }

    public void setSendBufferSize(int size) throws SocketException {
        this.wrappedSocket.setSendBufferSize(size);
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.wrappedSocket.setSoLinger(on, linger);
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.wrappedSocket.setSoTimeout(timeout);
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.wrappedSocket.setTcpNoDelay(on);
    }

    public void setTrafficClass(int tc) throws SocketException {
        this.wrappedSocket.setTrafficClass(tc);
    }

    public void shutdownInput() throws IOException {
        this.wrappedSocket.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.wrappedSocket.shutdownOutput();
    }

    public String toString() {
        return this.wrappedSocket.toString();
    }
}

