/*
 * Decompiled with CFR 0.152.
 */
package at.telekom.util.axis;

import at.telekom.util.axis.AxisDebugLogHandler;
import java.io.File;
import java.util.Hashtable;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisProperties;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.SimpleChain;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.configuration.SimpleProvider;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.transport.http.HTTPSender;

public class SSLClientAxisEngineConfig
extends SimpleProvider {
    private String keystore = null;
    private String keystoretype = null;
    private String keystorepin = null;
    private String truststore = null;
    private String truststorepin = null;
    private String truststoreType = null;
    private AxisDebugLogHandler logHandler = null;
    private File debugBaseDir = null;
    private boolean disablePrettyXML = true;
    private boolean enableNamespacePrefixOptimization = false;

    public SSLClientAxisEngineConfig() {
    }

    public SSLClientAxisEngineConfig(EngineConfiguration arg0) {
        super(arg0);
    }

    public SSLClientAxisEngineConfig(TypeMappingRegistry arg0) {
        super(arg0);
    }

    public void configureEngine(AxisEngine engine) throws ConfigurationException {
        super.configureEngine(engine);
        engine.refreshGlobalOptions();
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    public void setKeystorePassword(String keystorepin) {
        this.keystorepin = keystorepin;
    }

    public void setKeystoreType(String keystoretype) {
        this.keystoretype = keystoretype;
    }

    public void setTruststore(String truststore) {
        this.truststore = truststore;
    }

    public void setTruststorePassword(String truststorepin) {
        this.truststorepin = truststorepin;
    }

    public String getTruststoreType() {
        return this.truststoreType;
    }

    public void setTruststoreType(String truststoreType) {
        this.truststoreType = truststoreType;
    }

    public void initialize() {
        this.initialize(false);
    }

    public void initialize(boolean logging) {
        AxisProperties.setProperty((String)"axis.socketSecureFactory", (String)"at.telekom.util.axis.SecureSocketFactory");
        AxisProperties.setProperty((String)"axis.socketFactory", (String)"org.apache.axis.components.net.DefaultSocketFactory");
        Hashtable<String, Boolean> opts = new Hashtable<String, Boolean>();
        opts.put("disablePrettyXML", this.disablePrettyXML);
        opts.put("enableNamespacePrefixOptimization", this.enableNamespacePrefixOptimization);
        this.setGlobalOptions(opts);
        HTTPSender pivot = new HTTPSender();
        if (this.keystore != null) {
            pivot.setOption("clientauth", (Object)"true");
            pivot.setOption("keystore", (Object)this.keystore);
            if (this.keystoretype != null) {
                pivot.setOption("keystoreType", (Object)this.keystoretype);
            }
            if (this.keystorepin != null) {
                pivot.setOption("keypass", (Object)this.keystorepin);
                pivot.setOption("keystorePass", (Object)this.keystorepin);
            }
        }
        if (this.truststore != null) {
            pivot.setOption("truststore", (Object)this.truststore);
            if (this.truststoreType != null) {
                pivot.setOption("truststoreType", (Object)this.truststoreType);
            }
            if (this.truststorepin != null) {
                pivot.setOption("truststorePass", (Object)this.truststorepin);
            }
        }
        if (logging && this.debugBaseDir != null) {
            pivot.setOption("httplogdirectory", (Object)this.debugBaseDir.getAbsolutePath());
        }
        SimpleTargetedChain transport = null;
        if (logging) {
            SimpleChain reqHandler = new SimpleChain();
            SimpleChain respHandler = new SimpleChain();
            this.logHandler = new AxisDebugLogHandler();
            if (this.debugBaseDir != null) {
                this.logHandler.setBaseDir(this.debugBaseDir);
            }
            reqHandler.addHandler((Handler)this.logHandler);
            respHandler.addHandler((Handler)this.logHandler);
            transport = new SimpleTargetedChain((Handler)reqHandler, (Handler)pivot, (Handler)respHandler);
        } else {
            transport = new SimpleTargetedChain((Handler)pivot);
        }
        this.deployTransport("http", (Handler)transport);
    }

    public AxisDebugLogHandler getLogHandler() {
        return this.logHandler;
    }

    public File getDebugBaseDir() {
        return this.debugBaseDir;
    }

    public void setDebugBaseDir(File debugBaseDir) {
        this.debugBaseDir = debugBaseDir;
    }

    public boolean isDisablePrettyXML() {
        return this.disablePrettyXML;
    }

    public void setDisablePrettyXML(boolean disablePrettyXML) {
        this.disablePrettyXML = disablePrettyXML;
    }

    public boolean isEnableNamespacePrefixOptimization() {
        return this.enableNamespacePrefixOptimization;
    }

    public void setEnableNamespacePrefixOptimization(boolean enableNamespacePrefixOptimization) {
        this.enableNamespacePrefixOptimization = enableNamespacePrefixOptimization;
    }
}

