/*
 * Decompiled with CFR 0.152.
 */
package at.telekom.util.axis;

import at.telekom.util.axis.LoggingSocket;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManagerFactory;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Hashtable;
import org.apache.axis.components.net.BooleanHolder;
import org.apache.axis.components.net.SunJSSESocketFactory;

public class SecureSocketFactory
extends SunJSSESocketFactory {
    public SecureSocketFactory(Hashtable attributes) {
        super(attributes);
    }

    public Socket create(String arg0, int arg1, StringBuffer arg2, BooleanHolder arg3) throws Exception {
        Socket sock = super.create(arg0, arg1, arg2, arg3);
        String httpLogDir = (String)this.attributes.get("httplogdirectory");
        if (httpLogDir != null) {
            LoggingSocket logSock = new LoggingSocket(sock, httpLogDir);
            return logSock;
        }
        return sock;
    }

    protected SSLContext getContext() throws Exception {
        String algorithm;
        String protocol;
        String truststoreType;
        String truststoreFile;
        String truststorePass;
        String keystorePass;
        String keyPass;
        String keystoreType;
        if (this.attributes == null) {
            SSLContext context = SSLContext.getInstance((String)"SSL");
            context.init(null, null, null);
            return context;
        }
        String keystoreFile = (String)this.attributes.get("keystore");
        if (keystoreFile == null) {
            keystoreFile = String.valueOf(System.getProperty("user.home")) + "/.keystore";
        }
        if ((keystoreType = (String)this.attributes.get("keystoreType")) == null) {
            keystoreType = "JKS";
        }
        if ((keyPass = (String)this.attributes.get("keypass")) == null) {
            keyPass = "changeit";
        }
        if ((keystorePass = (String)this.attributes.get("keystorePass")) == null) {
            keystorePass = keyPass;
        }
        if ((truststorePass = (String)this.attributes.get("truststorePass")) == null) {
            truststorePass = keyPass;
        }
        if ((truststoreFile = (String)this.attributes.get("truststore")) == null) {
            truststoreFile = String.valueOf(System.getProperty("user.home")) + "/.truststore";
        }
        if ((truststoreType = (String)this.attributes.get("truststoreType")) == null) {
            truststoreType = "JKS";
        }
        if ((protocol = (String)this.attributes.get("protocol")) == null) {
            protocol = "TLS";
        }
        if ((algorithm = (String)this.attributes.get("algorithm")) == null) {
            algorithm = "SunX509";
        }
        KeyStore kstore = this.initKeyStore(keystoreFile, keystorePass, keystoreType);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance((String)algorithm);
        kmf.init(kstore, keyPass.toCharArray());
        KeyStore tStore = this.initKeyStore(truststoreFile, truststorePass, truststoreType);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance((String)"SunX509");
        tmf.init(tStore);
        SSLContext context = SSLContext.getInstance((String)protocol);
        context.init(kmf.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
        return context;
    }

    protected KeyStore initKeyStore(String keystoreFile, String keyPass, String type) throws IOException {
        try {
            KeyStore kstore = KeyStore.getInstance(type);
            FileInputStream istream = new FileInputStream(keystoreFile);
            kstore.load(istream, keyPass.toCharArray());
            return kstore;
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException("Exception trying to load keystore " + keystoreFile + ": " + ex.getMessage());
        }
    }
}

