/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.net;

import java.util.HashMap;
import java.util.Hashtable;
import org.apache.axis.AxisProperties;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.components.net.SecureSocketFactory;
import org.apache.axis.components.net.SocketFactory;
import org.apache.commons.logging.Log;

public class SocketFactoryFactory {
    protected static Log log = LogFactory.getLog((String)SocketFactoryFactory.class.getName());
    private static HashMap<String, SocketFactory> factories = new HashMap();
    private static HashMap<String, SocketFactory> sslFactories = new HashMap();
    private static final Class[] classes = new Class[]{Hashtable.class};

    static {
        AxisProperties.setClassOverrideProperty(SocketFactory.class, (String)"axis.socketFactory");
        AxisProperties.setClassDefault(SocketFactory.class, (String)"org.apache.axis.components.net.DefaultSocketFactory");
        AxisProperties.setClassOverrideProperty(SecureSocketFactory.class, (String)"axis.socketSecureFactory");
        AxisProperties.setClassDefault(SecureSocketFactory.class, (String)"org.apache.axis.components.net.JSSESocketFactory");
    }

    public static synchronized SocketFactory getFactory(String protocol, Hashtable attributes) {
        SocketFactory theFactory = null;
        String sslAttributeString = null;
        log.debug((Object)("Getting socketfactory for protocol: " + protocol));
        if (protocol.equalsIgnoreCase("https")) {
            sslAttributeString = attributes.get("keystore") + ";;" + (String)attributes.get("truststore");
            theFactory = sslFactories.get(sslAttributeString);
        } else {
            theFactory = factories.get(protocol.toLowerCase());
        }
        if (theFactory == null) {
            Object[] objects = new Object[]{attributes};
            log.debug((Object)("New socketfactory created for protocol: " + protocol));
            if (protocol.equalsIgnoreCase("http")) {
                theFactory = (SocketFactory)AxisProperties.newInstance(SocketFactory.class, (Class[])classes, (Object[])objects);
                if (theFactory != null) {
                    factories.put("http", theFactory);
                }
            } else if (protocol.equalsIgnoreCase("https")) {
                theFactory = (SecureSocketFactory)AxisProperties.newInstance(SecureSocketFactory.class, (Class[])classes, (Object[])objects);
                if (theFactory != null) {
                    sslFactories.put(sslAttributeString, theFactory);
                }
            } else {
                throw new IllegalArgumentException("Unknown Protocol type: " + protocol);
            }
        }
        return theFactory;
    }
}

